/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.modelbus.desktop.action.ModelBusManagerActionFactory;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction newWizardsAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private IContributionItem viewsShortList;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private IAction loginLogoutAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.newWizardsAction = ActionFactory.NEW.create(window);
        this.newWizardsAction.setText("New...");
        this.register((IAction)this.newWizardsAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.resetPerspectiveAction);
        this.viewsShortList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.loginLogoutAction = ModelBusManagerActionFactory.getInstance().create("loginLogout", window.getShell());
        this.register(this.loginLogoutAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager windowMenu = new MenuManager("&Application", "window");
        menuBar.add((IContributionItem)windowMenu);
        windowMenu.add((IAction)this.newWizardsAction);
        windowMenu.add((IAction)this.preferencesAction);
        windowMenu.add((IAction)this.resetPerspectiveAction);
        MenuManager viewsMenu = new MenuManager("Show &View");
        viewsMenu.add((IAction)new Action("Login View"){

            public void run() {
                IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = dw.getActivePage();
                try {
                    page.showView("org.modelbus.desktop.loginview");
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        viewsMenu.add(this.viewsShortList);
        windowMenu.add((IContributionItem)viewsMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        MenuManager helpMenu = new MenuManager("&Help", "help");
        menuBar.add((IContributionItem)helpMenu);
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IContributionItem)new Separator());
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(coolBar.getStyle());
        coolBar.add((IToolBarManager)toolbar);
        toolbar.add((IAction)this.newWizardsAction);
        toolbar.add((IAction)this.saveAction);
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        toolbar.add(this.loginLogoutAction);
    }
}

