/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.export;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.desktop.export.JobDescriptor;

public class ExportRepositoryItemsDialog
extends TitleAreaDialog {
    private final JobDescriptor job;

    public ExportRepositoryItemsDialog(Shell parentShell, JobDescriptor job) {
        super(parentShell);
        this.job = job;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText("Download");
        this.setTitle("Download Resources");
        this.setMessage("The repository content is available for download using the following link");
        return contents;
    }

    private String createDownloadHtml(String text) {
        StringBuilder html = new StringBuilder();
        html.append("<p style=\"font-family:Arial; Verdana; font-size:10pt; padding:10px;\">Download the repository content as a <a href=\"");
        html.append(this.createDownloadUrl());
        html.append("\">");
        html.append(text);
        html.append("</a>.</p>");
        return html.toString();
    }

    private String createDownloadUrl() {
        StringBuilder url = new StringBuilder();
        url.append(RWT.getRequest().getContextPath());
        url.append(RWT.getRequest().getServletPath());
        url.append("?");
        url.append("custom_service_handler");
        url.append("=exportServiceHandler");
        url.append("&jobID=");
        url.append(this.job.getID());
        String encodedURL = RWT.getResponse().encodeURL(url.toString());
        return encodedURL;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite downloadComposite = new Composite(area, 0);
        downloadComposite.setLayout((Layout)new FillLayout(256));
        downloadComposite.setLayoutData((Object)new GridData(1808));
        Browser browser = new Browser(downloadComposite, 0);
        browser.setText(this.createDownloadHtml("ZIP file"));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }
}

