/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ModelElementUtil {
    private static final int LABEL_FEATURE_COUNT = 3;
    public static final int MAX_LABEL_LENGTH = 50;

    public static String getElementLabelReflectively(EObject element, boolean includeType) {
        Object nameValue;
        String label = null;
        label = includeType ? String.valueOf(element.eClass().getName()) + " " : "";
        EStructuralFeature nameFeature = element.eClass().getEStructuralFeature("name");
        boolean nameFeatureUsed = false;
        if (nameFeature != null && (nameValue = element.eGet(nameFeature)) != null) {
            label = String.valueOf(label) + nameValue;
            nameFeatureUsed = true;
        }
        if (!nameFeatureUsed) {
            EList features = element.eClass().getEAllStructuralFeatures();
            int featureCount = 0;
            ArrayList<String> featureValues = new ArrayList<String>();
            for (EStructuralFeature feature : features) {
                if (featureCount >= 3) break;
                Object featureValue = element.eGet(feature);
                if (featureValue == null || featureValue instanceof EObject || featureValue instanceof List) continue;
                featureValues.add(String.valueOf(feature.getName()) + ": " + ModelElementUtil._processLabel(featureValue.toString(), true));
                ++featureCount;
            }
            if (!featureValues.isEmpty()) {
                label = String.valueOf(label) + ModelElementUtil.joinStringCollection(featureValues, ", ");
            }
        }
        if (label.equals("")) {
            return element.toString();
        }
        return label;
    }

    public static String joinStringCollection(Collection<String> col, String delimiter) {
        return ModelElementUtil.joinStringArray(col.toArray(new String[col.size()]), delimiter);
    }

    public static String joinStringArray(String[] array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i]);
            if (i < array.length - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String _processLabel(String label, boolean shorten) {
        if (!shorten) {
            return label;
        }
        if (label.length() > 50) {
            return label.substring(0, 50).concat("...");
        }
        return label;
    }
}

