/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.user;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.modelbus.desktop.user.GenericMapCellLabelProvider;
import org.modelbus.desktop.user.UserModelEditorInput;
import org.modelbus.desktop.user.UserModelProvider;
import org.modelbus.desktop.user.UserRightDialog;
import org.modelbus.desktop.user.UsersView;
import org.modelbus.model.user.NamedElement;
import org.modelbus.model.user.Rule;
import org.modelbus.model.user.RuleElement;
import org.modelbus.model.user.User;
import org.modelbus.model.user.UserFactory;
import org.modelbus.model.user.UserGroup;
import org.modelbus.model.user.UserModel;
import org.modelbus.model.user.UserPackage;

public class UserModelEditor
extends EditorPart {
    public static final String ID = "org.modelbus.desktop.UserEditor";
    protected boolean isDirty = false;
    protected EMFDataBindingContext ctx;
    private TableViewer listViewerLeft;
    private TableViewer listViewerRight;
    private Rule selectedRule = null;
    private UserGroup selectedUserGroupLeft;
    private UserGroup selectedUserGroupRight;
    private ComboViewer usersAndGroupsComboViewer;
    private Text usernameInput;
    private Label lblPassword;
    private Text passwordInput;
    private Composite userGroupsComposite;
    private Composite userGroupsLabelComposite;
    private IObservableList lst;
    private IObservableValue selectedElementMaster;

    public void doSave(IProgressMonitor monitor) {
        UserModelProvider.commitUserModelChanges();
        this.setDirty(false);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (input == null || !(input instanceof UserModelEditorInput)) {
            throw new IllegalArgumentException("UserEditor requires editor input of type " + UserModelEditorInput.class.getName());
        }
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private UserModel getUserModel() {
        UserModelEditorInput input = (UserModelEditorInput)this.getEditorInput();
        return input.getUserModel();
    }

    private void updateUI(NamedElement forElement) {
        boolean isUser = forElement instanceof User;
        this.lblPassword.setVisible(isUser);
        this.passwordInput.setVisible(isUser);
        this.userGroupsComposite.setVisible(isUser);
        this.userGroupsLabelComposite.setVisible(isUser);
        if (!isUser) {
            if (this.lst != null) {
                this.listViewerRight.setInput(null);
                this.lst.dispose();
                this.lst = null;
            }
        } else {
            this.selectedElementMaster.setValue((Object)forElement);
            IEMFListProperty userGroupElements = EMFProperties.list((EStructuralFeature)UserPackage.Literals.USER__USERGROUPS);
            this.lst = userGroupElements.observeDetail(this.selectedElementMaster);
            this.listViewerRight.setInput((Object)this.lst);
            this.listViewerLeft.refresh();
            this.listViewerRight.refresh();
        }
        if (!isUser) {
            this.selectedElementMaster.setValue((Object)forElement);
        }
    }

    public void createPartControl(final Composite parent) {
        this.ctx = new EMFDataBindingContext();
        FontData headlineFontData = new FontData("Segoe UI", 14, 1);
        Font headlineFont = new Font((Device)parent.getDisplay(), headlineFontData);
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new FillLayout(256));
        final ScrolledComposite revisionScrolledComposite = new ScrolledComposite(outerContainer, 768);
        revisionScrolledComposite.setLayout((Layout)new FillLayout(256));
        revisionScrolledComposite.setExpandHorizontal(true);
        revisionScrolledComposite.setExpandVertical(true);
        final Composite container = new Composite((Composite)revisionScrolledComposite, 0);
        revisionScrolledComposite.setContent((Control)container);
        revisionScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = revisionScrolledComposite.getClientArea();
                revisionScrolledComposite.setMinSize(container.computeSize(r.width, -1));
            }
        });
        container.setLayout((Layout)new GridLayout(2, false));
        CCombo usersAndGroupsCombo = new CCombo(container, 2056);
        usersAndGroupsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.usersAndGroupsComboViewer = new ComboViewer(usersAndGroupsCombo);
        this.selectedElementMaster = new WritableValue();
        IViewerObservableValue selectedElement = ViewerProperties.singleSelection().observe((Viewer)this.usersAndGroupsComboViewer);
        selectedElement.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (event.diff.getNewValue() instanceof NamedElement) {
                    NamedElement element = (NamedElement)event.diff.getNewValue();
                    UserModelEditor.this.updateUI(element);
                }
            }
        });
        ObservableListContentProvider usersAndGroupsContentProvider = new ObservableListContentProvider();
        this.usersAndGroupsComboViewer.setContentProvider((IContentProvider)usersAndGroupsContentProvider);
        IObservableMap usersAndGroupsAttributeMap = EMFProperties.value((EStructuralFeature)UserPackage.Literals.NAMED_ELEMENT__NAME).observeDetail(usersAndGroupsContentProvider.getKnownElements());
        this.usersAndGroupsComboViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(usersAndGroupsAttributeMap){

            public String getText(Object element) {
                if (element instanceof NamedElement) {
                    NamedElement measure = (NamedElement)element;
                    return measure.getName();
                }
                return super.getText(element);
            }
        });
        IEMFListProperty usersAndGroups = EMFProperties.multiList((EStructuralFeature[])new EStructuralFeature[]{UserPackage.Literals.USER_MODEL__OWNED_USER_GROUP, UserPackage.Literals.USER_MODEL__OWNED_USER});
        this.usersAndGroupsComboViewer.setInput((Object)usersAndGroups.observe((Object)this.getUserModel()));
        Composite credentialsHeadline = new Composite(container, 0);
        credentialsHeadline.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.marginHeight = 0;
        gl_composite_3.marginTop = 15;
        gl_composite_3.marginWidth = 0;
        gl_composite_3.horizontalSpacing = 0;
        credentialsHeadline.setLayout((Layout)gl_composite_3);
        Label lblUserCredentials = new Label(credentialsHeadline, 0);
        lblUserCredentials.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        lblUserCredentials.setFont(headlineFont);
        Label lblUsername = new Label(container, 0);
        lblUsername.setText("Name:");
        GridData usernameLayoutData = new GridData(131072, 0x1000000, false, false, 1, 1);
        usernameLayoutData.widthHint = 100;
        lblUsername.setLayoutData((Object)usernameLayoutData);
        this.usernameInput = new Text(container, 2048);
        GridData textInputLayoutData = new GridData(16384, 0x1000000, true, false, 1, 1);
        textInputLayoutData.widthHint = 400;
        this.usernameInput.setLayoutData((Object)textInputLayoutData);
        IEMFValueProperty nameProperty = EMFProperties.value((EStructuralFeature)UserPackage.Literals.NAMED_ELEMENT__NAME);
        IWidgetValueProperty nameWidgetProperty = WidgetProperties.text((int)24);
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                UserModelEditor.this.setDirty(true);
            }
        };
        UserModelProvider.getUserModel().eResource().eAdapters().add((Object)adapter);
        UserModelProvider.getUserModel().eResource().setTrackingModification(true);
        IObservableValue nameValue = nameProperty.observeDetail(this.selectedElementMaster);
        this.ctx.bindValue((IObservableValue)nameWidgetProperty.observeDelayed(400, (Widget)this.usernameInput), nameValue);
        this.lblPassword = new Label(container, 0);
        this.lblPassword.setText("Password:");
        this.passwordInput = new Text(container, 0x400800);
        this.passwordInput.setLayoutData((Object)textInputLayoutData);
        IEMFValueProperty passwordProperty = EMFProperties.value((EStructuralFeature)UserPackage.Literals.USER__PASSWORD);
        IWidgetValueProperty passwordWidgetProperty = WidgetProperties.text((int)24);
        IObservableValue passwordValue = passwordProperty.observeDetail(this.selectedElementMaster);
        this.ctx.bindValue((IObservableValue)passwordWidgetProperty.observeDelayed(400, (Widget)this.passwordInput), passwordValue);
        Composite rightsLabelComposite = new Composite(container, 0);
        rightsLabelComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout rightsLabelCompositeLayout = new GridLayout(1, false);
        rightsLabelCompositeLayout.marginWidth = 0;
        rightsLabelCompositeLayout.marginHeight = 0;
        rightsLabelCompositeLayout.marginTop = 15;
        rightsLabelComposite.setLayout((Layout)rightsLabelCompositeLayout);
        Label lblAccessRights = new Label(rightsLabelComposite, 0);
        lblAccessRights.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblAccessRights.setText("Access Rights");
        lblAccessRights.setFont(headlineFont);
        Label lblAccessRules = new Label(container, 0);
        lblAccessRules.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblAccessRules.setText("Access Rules:");
        Composite accessRulesComposite = new Composite(container, 0);
        accessRulesComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout accessRulesCompositeLayout = new GridLayout(2, false);
        accessRulesCompositeLayout.marginHeight = 0;
        accessRulesCompositeLayout.marginWidth = 0;
        accessRulesComposite.setLayout((Layout)accessRulesCompositeLayout);
        Composite tableComposite = new Composite(accessRulesComposite, 0);
        GridData tableLayoutData = new GridData(16384, 4, false, true, 1, 1);
        tableLayoutData.heightHint = 100;
        tableLayoutData.widthHint = 400;
        tableComposite.setLayoutData((Object)tableLayoutData);
        TableViewer accessRightsTableViewer = new TableViewer(tableComposite, 67584);
        accessRightsTableViewer.getTable().setLinesVisible(false);
        accessRightsTableViewer.getTable().setHeaderVisible(true);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        accessRightsTableViewer.setContentProvider((IContentProvider)cp);
        accessRightsTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        IObservableMap[] attributeMaps = new IObservableMap[]{EMFProperties.value((EStructuralFeature)UserPackage.Literals.RULE__RULE).observeDetail(cp.getKnownElements()), EMFProperties.value((EStructuralFeature)UserPackage.Literals.RULE__MASK).observeDetail(cp.getKnownElements())};
        TableViewerColumn columnRule = new TableViewerColumn(accessRightsTableViewer, 16384);
        columnRule.getColumn().setText("Rule");
        columnRule.getColumn().setMoveable(true);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        tableColumnLayout.setColumnData((Widget)columnRule.getColumn(), (ColumnLayoutData)new ColumnWeightData(75));
        GenericMapCellLabelProvider labelProviderColumnRule = new GenericMapCellLabelProvider("{0}", attributeMaps);
        columnRule.setLabelProvider((CellLabelProvider)labelProviderColumnRule);
        TableViewerColumn columnMask = new TableViewerColumn(accessRightsTableViewer, 16384);
        columnMask.getColumn().setText("Mask");
        columnMask.getColumn().setMoveable(true);
        tableColumnLayout.setColumnData((Widget)columnMask.getColumn(), (ColumnLayoutData)new ColumnWeightData(25));
        GenericMapCellLabelProvider labelProviderColumnMask = new GenericMapCellLabelProvider("{1}", attributeMaps);
        columnMask.setLabelProvider((CellLabelProvider)labelProviderColumnMask);
        IEMFListProperty ruleElements = EMFProperties.list((EStructuralFeature)UserPackage.Literals.RULE_ELEMENT__OWNED_RULE);
        accessRightsTableViewer.setInput((Object)ruleElements.observeDetail(this.selectedElementMaster));
        Composite accessRightsButtonsComposite = new Composite(accessRulesComposite, 0);
        GridData accessRightsButtonsCompositeLayoutData = new GridData(16384, 128, false, false, 1, 1);
        accessRightsButtonsCompositeLayoutData.widthHint = 60;
        accessRightsButtonsComposite.setLayoutData((Object)accessRightsButtonsCompositeLayoutData);
        GridLayout accessRightsButtonsCompositeLayout = new GridLayout(1, false);
        accessRightsButtonsCompositeLayout.marginWidth = 0;
        accessRightsButtonsCompositeLayout.verticalSpacing = 3;
        accessRightsButtonsCompositeLayout.marginHeight = 0;
        accessRightsButtonsComposite.setLayout((Layout)accessRightsButtonsCompositeLayout);
        final Button btnEditRule = new Button(accessRightsButtonsComposite, 0);
        btnEditRule.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnEditRule.setText("Edit...");
        btnEditRule.setEnabled(false);
        btnEditRule.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (UserModelEditor.this.selectedRule == null) {
                    return;
                }
                UserRightDialog dialog = new UserRightDialog(parent.getShell(), UserModelEditor.this.selectedRule);
                int result = dialog.open();
                if (result == 0) {
                    UserModelEditor.this.setDirty(true);
                }
            }
        });
        Button btnNewRule = new Button(accessRightsButtonsComposite, 0);
        btnNewRule.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnNewRule.setText("New...");
        btnNewRule.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object master;
                Rule newRule = UserFactory.eINSTANCE.createRule();
                UserRightDialog dialog = new UserRightDialog(parent.getShell(), newRule);
                int result = dialog.open();
                if (result == 0 && (master = UserModelEditor.this.selectedElementMaster.getValue()) instanceof RuleElement) {
                    ((RuleElement)master).getOwnedRule().add((Object)newRule);
                    UserModelEditor.this.setDirty(true);
                }
            }
        });
        final Button btnDeleteRule = new Button(accessRightsButtonsComposite, 0);
        btnDeleteRule.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnDeleteRule.setText("Delete");
        btnDeleteRule.setEnabled(false);
        btnDeleteRule.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (UserModelEditor.this.selectedRule == null) {
                    return;
                }
                boolean delete = MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Delete Access Rule", (String)"Do you want to delete the access rule?");
                if (delete) {
                    EcoreUtil.delete((EObject)UserModelEditor.this.selectedRule);
                    UserModelEditor.this.selectedRule = null;
                }
            }
        });
        IViewerObservableValue selectedValue = ViewerProperties.singleSelection().observe((Viewer)accessRightsTableViewer);
        selectedValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                boolean isRule = event.diff.getNewValue() instanceof Rule;
                if (isRule) {
                    UserModelEditor.this.selectedRule = (Rule)event.diff.getNewValue();
                }
                btnDeleteRule.setEnabled(isRule);
                btnEditRule.setEnabled(isRule);
            }
        });
        this.userGroupsLabelComposite = new Composite(container, 0);
        this.userGroupsLabelComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout userGroupsLabelCompositeLayoutData = new GridLayout(1, false);
        userGroupsLabelCompositeLayoutData.marginTop = 15;
        userGroupsLabelCompositeLayoutData.verticalSpacing = 0;
        userGroupsLabelCompositeLayoutData.marginWidth = 0;
        userGroupsLabelCompositeLayoutData.horizontalSpacing = 0;
        userGroupsLabelCompositeLayoutData.marginHeight = 0;
        this.userGroupsLabelComposite.setLayout((Layout)userGroupsLabelCompositeLayoutData);
        Label lblUsergroups = new Label(this.userGroupsLabelComposite, 0);
        lblUsergroups.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblUsergroups.setFont(headlineFont);
        lblUsergroups.setText("Usergroups");
        this.userGroupsComposite = new Composite(container, 0);
        GridLayout userGroupsCompositeLayoutData = new GridLayout(3, false);
        userGroupsCompositeLayoutData.marginHeight = 0;
        userGroupsCompositeLayoutData.marginWidth = 0;
        this.userGroupsComposite.setLayout((Layout)userGroupsCompositeLayoutData);
        this.userGroupsComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Composite tableCompositeUserGroupsAv = new Composite(this.userGroupsComposite, 0);
        GridData tableCompositeUserGroupsAvLayoutData = new GridData(4, 4, true, true, 1, 1);
        tableCompositeUserGroupsAvLayoutData.widthHint = 225;
        tableCompositeUserGroupsAvLayoutData.heightHint = 200;
        tableCompositeUserGroupsAv.setLayoutData((Object)tableCompositeUserGroupsAvLayoutData);
        this.listViewerLeft = new TableViewer(tableCompositeUserGroupsAv, 67584);
        this.listViewerLeft.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ObservableListContentProvider cpAvUserGroup = new ObservableListContentProvider();
        this.listViewerLeft.setContentProvider((IContentProvider)cpAvUserGroup);
        this.listViewerLeft.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof UserGroup) {
                    UserGroup userGroup = (UserGroup)element;
                    Object master = UserModelEditor.this.selectedElementMaster.getValue();
                    if (master instanceof User) {
                        return !((User)master).getUsergroups().contains((Object)userGroup);
                    }
                    return false;
                }
                return false;
            }
        });
        IObservableMap[] attributeMapsUserGroupLeft = new IObservableMap[]{EMFProperties.value((EStructuralFeature)UserPackage.Literals.NAMED_ELEMENT__NAME).observeDetail(cpAvUserGroup.getKnownElements())};
        TableViewerColumn columnUserGroupNameLeft = new TableViewerColumn(this.listViewerLeft, 16384);
        columnUserGroupNameLeft.getColumn().setText("Name");
        TableColumnLayout columnUserGroupLeftLayout = new TableColumnLayout();
        tableCompositeUserGroupsAv.setLayout((Layout)columnUserGroupLeftLayout);
        columnUserGroupLeftLayout.setColumnData((Widget)columnUserGroupNameLeft.getColumn(), (ColumnLayoutData)new ColumnWeightData(99));
        GenericMapCellLabelProvider labelProviderColumnUserGroupLeftName = new GenericMapCellLabelProvider("{0}", attributeMapsUserGroupLeft);
        columnUserGroupNameLeft.setLabelProvider((CellLabelProvider)labelProviderColumnUserGroupLeftName);
        IEMFListProperty userGroupElementsLeft = EMFProperties.list((EStructuralFeature)UserPackage.Literals.USER_MODEL__OWNED_USER_GROUP);
        this.listViewerLeft.setInput((Object)userGroupElementsLeft.observe((Object)this.getUserModel()));
        Composite buttonComposite = new Composite(this.userGroupsComposite, 0);
        GridData buttonCompositeLayoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        buttonCompositeLayoutData.widthHint = 50;
        buttonComposite.setLayoutData((Object)buttonCompositeLayoutData);
        GridLayout buttonCompositeLayout = new GridLayout(1, false);
        buttonCompositeLayout.horizontalSpacing = 0;
        buttonCompositeLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        final Button addButton = new Button(buttonComposite, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        addButton.setText(">>");
        addButton.setEnabled(false);
        addButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object master;
                if (UserModelEditor.this.selectedUserGroupLeft != null && (master = UserModelEditor.this.selectedElementMaster.getValue()) instanceof User) {
                    ((User)master).getUsergroups().add((Object)UserModelEditor.this.selectedUserGroupLeft);
                    UserModelEditor.this.listViewerLeft.refresh();
                    UserModelEditor.this.setDirty(true);
                    UsersView usersView = UserModelEditor.this.getUsersView();
                    if (usersView != null) {
                        usersView.refresh();
                    }
                }
            }
        });
        final Button removeButton = new Button(buttonComposite, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        removeButton.setText("<<");
        removeButton.setEnabled(false);
        removeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object master;
                if (UserModelEditor.this.selectedUserGroupRight != null && (master = UserModelEditor.this.selectedElementMaster.getValue()) instanceof User) {
                    ((User)master).getUsergroups().remove((Object)UserModelEditor.this.selectedUserGroupRight);
                    UserModelEditor.this.listViewerLeft.refresh();
                    UserModelEditor.this.setDirty(true);
                    UsersView usersView = UserModelEditor.this.getUsersView();
                    if (usersView != null) {
                        usersView.refresh();
                    }
                }
            }
        });
        Composite tableCompositeUserGroupsSet = new Composite(this.userGroupsComposite, 0);
        GridData tableCompositeUserGroupsLayoutData = new GridData(4, 4, true, true, 1, 1);
        tableCompositeUserGroupsLayoutData.widthHint = 225;
        tableCompositeUserGroupsLayoutData.heightHint = 200;
        tableCompositeUserGroupsSet.setLayoutData((Object)tableCompositeUserGroupsLayoutData);
        this.listViewerRight = new TableViewer(tableCompositeUserGroupsSet, 67584);
        this.listViewerRight.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ObservableListContentProvider cpUserGroup = new ObservableListContentProvider();
        this.listViewerRight.setContentProvider((IContentProvider)cpUserGroup);
        IObservableMap[] attributeMapsUserGroup = new IObservableMap[]{EMFProperties.value((EStructuralFeature)UserPackage.Literals.NAMED_ELEMENT__NAME).observeDetail(cpUserGroup.getKnownElements())};
        TableViewerColumn columnUserGroupName = new TableViewerColumn(this.listViewerRight, 16384);
        columnUserGroupName.getColumn().setText("Name");
        TableColumnLayout columnUserGroupLayout = new TableColumnLayout();
        tableCompositeUserGroupsSet.setLayout((Layout)columnUserGroupLayout);
        columnUserGroupLayout.setColumnData((Widget)columnUserGroupName.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        GenericMapCellLabelProvider labelProviderColumnUserGroupName = new GenericMapCellLabelProvider("{0}", attributeMapsUserGroup);
        columnUserGroupName.setLabelProvider((CellLabelProvider)labelProviderColumnUserGroupName);
        IViewerObservableValue selectedValueAvUserGroup = ViewerProperties.singleSelection().observe((Viewer)this.listViewerLeft);
        selectedValueAvUserGroup.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                boolean isUserGroup = event.diff.getNewValue() instanceof UserGroup;
                if (isUserGroup) {
                    UserModelEditor.this.selectedUserGroupLeft = (UserGroup)event.diff.getNewValue();
                } else {
                    UserModelEditor.this.selectedUserGroupLeft = null;
                }
                addButton.setEnabled(isUserGroup);
            }
        });
        IViewerObservableValue selectedValueSetUserGroup = ViewerProperties.singleSelection().observe((Viewer)this.listViewerRight);
        selectedValueSetUserGroup.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                boolean isUserGroup = event.diff.getNewValue() instanceof UserGroup;
                if (isUserGroup) {
                    UserModelEditor.this.selectedUserGroupRight = (UserGroup)event.diff.getNewValue();
                } else {
                    UserModelEditor.this.selectedUserGroupRight = null;
                }
                removeButton.setEnabled(isUserGroup);
            }
        });
        this.setTitle(this.getEditorInput().getName());
        revisionScrolledComposite.setMinSize(container.computeSize(-1, -1));
    }

    private UsersView getUsersView() {
        IViewPart usersView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.modelbus.desktop.usersview");
        if (usersView instanceof UsersView) {
            return (UsersView)usersView;
        }
        return null;
    }

    public void setUserModelElement(NamedElement element) {
        this.usersAndGroupsComboViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    public void setFocus() {
    }
}

