/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.management.DefaultManagementMBeanAssembler;
import org.apache.camel.util.ObjectHelper;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

public class SpringManagementMBeanAssembler
extends DefaultManagementMBeanAssembler {
    private final MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler();

    public SpringManagementMBeanAssembler() {
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    @Override
    public ModelMBean assemble(MBeanServer mBeanServer, Object obj, ObjectName name) throws JMException {
        Object custom;
        ModelMBeanInfo mbi = null;
        if (obj instanceof ManagedInstance && (custom = ((ManagedInstance)obj).getInstance()) != null && ObjectHelper.hasAnnotation(custom.getClass().getAnnotations(), ManagedResource.class)) {
            this.log.trace("Assembling MBeanInfo for: {} from custom @ManagedResource object: {}", (Object)name, custom);
            mbi = this.assembler.getMBeanInfo(custom, name.toString());
            obj = custom;
        }
        if (mbi == null) {
            if (ObjectHelper.hasAnnotation(obj.getClass().getAnnotations(), ManagedResource.class)) {
                this.log.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", (Object)name, obj);
                mbi = this.assembler.getMBeanInfo(obj, name.toString());
            } else {
                return super.assemble(mBeanServer, obj, name);
            }
        }
        this.log.trace("Assembled MBeanInfo {}", mbi);
        RequiredModelMBean mbean = (RequiredModelMBean)mBeanServer.instantiate(RequiredModelMBean.class.getName());
        mbean.setModelMBeanInfo(mbi);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        return mbean;
    }
}

