/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.ws.Endpoint;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.jaxws.server.JaxWsServiceReference;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.eclipse.ecf.provider.jaxws.util.ServerUtil;
import org.eclipse.ecf.provider.jaxws.util.UriUtil;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;

public class JaxWsRemoteService
implements IRemoteServiceRegistration {
    private final ExecutorService pool;
    private final Endpoint endpoint;
    private Dictionary<?, ?> properties;
    private final ID containerID;
    private final IRemoteServiceID serviceID;
    private final IRemoteServiceReference serviceReference;

    public JaxWsRemoteService(String[] clazzes, Object service, JaxWsParams params, Dictionary properties, ID containerID, IRemoteServiceID serviceID) {
        this.properties = properties;
        this.containerID = containerID;
        this.serviceID = serviceID;
        this.serviceReference = new JaxWsServiceReference(this);
        JaxWsParams effectiveParams = params.clone();
        String uri = UriUtil.getPublishUri(params, containerID.getName());
        effectiveParams.setAddress(uri);
        this.pool = Executors.newCachedThreadPool();
        this.endpoint = ServerUtil.createEndpoint((Object)service, (JaxWsParams)effectiveParams, (Executor)this.pool);
    }

    public IRemoteServiceID getID() {
        return this.serviceID;
    }

    public ID getContainerID() {
        return this.containerID;
    }

    public IRemoteServiceReference getReference() {
        return this.serviceReference;
    }

    public void setProperties(Dictionary properties) {
        this.properties = properties;
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public String[] getPropertyKeys() {
        if (this.properties == null) {
            return new String[0];
        }
        Enumeration<?> keys = this.properties.keys();
        return this.keepStrings(Collections.list(keys)).toArray(new String[0]);
    }

    private ArrayList<String> keepStrings(ArrayList<?> list) {
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof String) continue;
            it.remove();
        }
        return list;
    }

    public void unregister() {
        this.endpoint.stop();
        this.pool.shutdown();
    }
}

