/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelbus.tools.diffmerge.model.AbstractDiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementCollection;
import org.modelbus.tools.diffmerge.model.DiffKind;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffModelException;
import org.modelbus.tools.diffmerge.model.DiffSource;
import org.modelbus.tools.diffmerge.model.DiffType;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public abstract class AbstractDiffElement
implements DiffElement {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractDiffModelElement.class.getName());
    private final Diff diff;
    private final Match match;
    private final DiffCollection<DiffElement> subDiffs = DiffElementCollection.createNewCollection();
    private final AbstractMerger merger;
    private final Monitor montior;
    private final DiffModelElement parent;

    protected AbstractDiffElement(DiffModelElement parent, Diff diff, AbstractMerger merger, Monitor monitor) {
        this.diff = diff;
        this.match = diff.getMatch();
        this.montior = monitor;
        this.merger = this.setMerger(merger);
        this.parent = parent;
    }

    private AbstractMerger setMerger(AbstractMerger merger) {
        if (merger.isMergerFor(this.diff)) {
            return merger;
        }
        throw new DiffModelException(String.format("Wrong merger of type: %s for Diff of type %s", merger.getClass().getName(), this.diff.getClass().getName()));
    }

    public EObject getLeftElement() {
        EObject left = this.match.getLeft();
        this.checkElement(left);
        return left;
    }

    private void checkElement(EObject element) {
        if (element == null) {
            LOG.error("There is no model element mapped on the left hand site of the DiffModel. Check your input resources.");
        }
    }

    public EObject getRightElement() {
        EObject right = this.match.getRight();
        this.checkElement(right);
        return right;
    }

    public Optional<EObject> getOriginElement() {
        return Optional.fromNullable((Object)this.match.getOrigin());
    }

    public boolean isConflict() {
        return this.diff.getConflict() != null;
    }

    public DiffKind getKind() {
        switch (this.diff.getKind()) {
            case ADD: {
                return DiffKind.Add;
            }
            case DELETE: {
                return DiffKind.Remove;
            }
            case CHANGE: {
                return DiffKind.Change;
            }
            case MOVE: {
                return DiffKind.Move;
            }
        }
        throw new DiffModelException("Unsupported kind: " + this.diff.getKind());
    }

    public Optional<DiffModelElement> getParentElement() {
        Preconditions.checkNotNull((Object)this.parent);
        return Optional.of((Object)this.parent);
    }

    public EObject getAffectedModelElement() {
        Optional<EObject> originElement;
        EObject element = this.getLeftElement();
        if (element == null) {
            element = this.getRightElement();
        }
        if (element == null && (originElement = this.getOriginElement()).isPresent()) {
            element = (EObject)originElement.get();
        }
        if (element == null) {
            throw new DiffModelException("No modelelement found");
        }
        return element;
    }

    public String toString() {
        Match match = this.diff.getMatch();
        EObject obj = match.getLeft();
        if (obj == null) {
            obj = match.getRight();
        }
        if (obj == null) {
            obj = match.getOrigin();
        }
        if (obj == null) {
            return this.diff.toString();
        }
        EStructuralFeature feature = obj.eClass().getEStructuralFeature("name");
        if (feature == null) {
            return "changens in <name feature not found>";
        }
        Object name = obj.eGet(feature);
        return "changes in: " + name;
    }

    public List<DiffModelElement> getSubElements() {
        return Lists.newArrayListWithCapacity((int)0);
    }

    public List<DiffModelElement> getAllSubElements() {
        return this.getSubElements();
    }

    public void mergeFromLeftToRight() {
        throw new UnsupportedOperationException();
    }

    public void mergeFromRightToLeft() {
        throw new UnsupportedOperationException();
    }

    public DiffCollection<DiffElement> getAllDiffElements() {
        return this.subDiffs;
    }

    public DiffCollection<DiffElement> getDiffElements() {
        return this.getAllDiffElements();
    }

    public Diff getDiff() {
        return this.diff;
    }

    public AbstractMerger getMerger() {
        return this.merger;
    }

    public Monitor getMonitor() {
        return this.montior;
    }

    boolean addLeaf(DiffElement leaf) {
        return this.subDiffs.add((Object[])new DiffElement[]{leaf});
    }

    public DiffSource getSource() {
        switch (this.diff.getSource()) {
            case RIGHT: {
                return DiffSource.Right;
            }
        }
        return DiffSource.Left;
    }

    public void removeSubElement(DiffModelElement element) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeConflictingSubElement(DiffModelElement conflictingElement) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public DiffCollection<DiffElement> getConflictingElements() {
        DiffCollection<DiffElement> conflicts = DiffElementCollection.createNewCollection();
        if (this.isConflict()) {
            conflicts.add((Object[])new DiffElement[]{this});
        }
        return conflicts;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.diff.hashCode(), this.match.hashCode(), this.merger.hashCode(), this.montior.hashCode(), this.parent.hashCode()});
    }

    public DiffType getDiffType() {
        if (this.diff instanceof AttributeChange) {
            return DiffType.ATTRIBUTE_CHANGE;
        }
        if (this.diff instanceof ReferenceChange) {
            return DiffType.REFERENCE_CHANGE;
        }
        if (this.diff instanceof ResourceAttachmentChange) {
            return DiffType.RESOURCE_CHANGE;
        }
        throw new DiffModelException("Unknown type: " + this.diff.getClass().getName());
    }
}

