/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.model;

import java.text.SimpleDateFormat;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.modelbus.desktop.repository.RevisionTableViewerContentProvider;
import org.modelbus.desktop.repository.RevisionTableViewerSorter;
import org.modelbus.desktop.util.RepositoryItemHelper;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryLogEntry;

public class SelectRevisionDialog
extends TitleAreaDialog {
    private static final long serialVersionUID = 902914657867366409L;
    public static final int COLUMN_REVISON = 0;
    public static final int COLUMN_DATE = 1;
    public static final int COLUMN_AUTHOR = 2;
    public static final int COLUMN_COMMENT = 3;
    private RepositoryDirEntry item;
    private TableViewer tableViewer;
    private ISelection selection;
    private String message;
    private boolean allRevisions;

    public SelectRevisionDialog(Shell parentShell, RepositoryDirEntry item, String message, boolean allRevisions) {
        super(parentShell);
        this.item = item;
        this.message = message;
        this.allRevisions = allRevisions;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText("Select Revision");
        this.setTitle("Select any of existing revisions");
        this.setMessage(this.message);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite tableComposite = new Composite(area, 0);
        tableComposite.setLayout((Layout)new FillLayout(256));
        tableComposite.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(tableComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new RevisionTableViewerContentProvider());
        this.tableViewer.setSorter((ViewerSorter)new RevisionTableViewerSorter());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectRevisionDialog.this.selection = SelectRevisionDialog.this.tableViewer.getSelection();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectRevisionDialog.this.close();
            }
        });
        TableViewerColumn columnRevision = new TableViewerColumn(this.tableViewer, 16384);
        columnRevision.getColumn().setText("Revision");
        columnRevision.getColumn().setMoveable(true);
        columnRevision.setLabelProvider(new CellLabelProvider(){
            private static final long serialVersionUID = 5297874959108533001L;

            public void update(ViewerCell cell) {
                RepositoryLogEntry entry = (RepositoryLogEntry)cell.getElement();
                cell.setText(String.valueOf(entry.getRevision()));
            }
        });
        columnRevision.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -3591176613165026675L;

            public void widgetSelected(SelectionEvent event) {
                ((RevisionTableViewerSorter)SelectRevisionDialog.this.tableViewer.getSorter()).doSort(0);
                SelectRevisionDialog.this.tableViewer.refresh();
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        tableColumnLayout.setColumnData((Widget)columnRevision.getColumn(), (ColumnLayoutData)new ColumnWeightData(20));
        TableViewerColumn columnDate = new TableViewerColumn(this.tableViewer, 16384);
        columnDate.getColumn().setText("Date");
        columnDate.getColumn().setMoveable(true);
        columnDate.setLabelProvider(new CellLabelProvider(){
            private static final long serialVersionUID = -1967789404085805034L;

            public void update(ViewerCell cell) {
                RepositoryLogEntry entry = (RepositoryLogEntry)cell.getElement();
                cell.setText(SimpleDateFormat.getDateTimeInstance().format(entry.getDate().toGregorianCalendar().getTime()));
            }
        });
        columnDate.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 4279997136730613551L;

            public void widgetSelected(SelectionEvent event) {
                ((RevisionTableViewerSorter)SelectRevisionDialog.this.tableViewer.getSorter()).doSort(1);
                SelectRevisionDialog.this.tableViewer.refresh();
            }
        });
        tableColumnLayout.setColumnData((Widget)columnDate.getColumn(), (ColumnLayoutData)new ColumnWeightData(20));
        TableViewerColumn columnAuthor = new TableViewerColumn(this.tableViewer, 16384);
        columnAuthor.getColumn().setText("Author");
        columnAuthor.getColumn().setMoveable(true);
        columnAuthor.setLabelProvider(new CellLabelProvider(){
            private static final long serialVersionUID = -7641325256315155950L;

            public void update(ViewerCell cell) {
                RepositoryLogEntry entry = (RepositoryLogEntry)cell.getElement();
                cell.setText(entry.getAuthor());
            }
        });
        columnAuthor.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 3030294798644875420L;

            public void widgetSelected(SelectionEvent event) {
                ((RevisionTableViewerSorter)SelectRevisionDialog.this.tableViewer.getSorter()).doSort(2);
                SelectRevisionDialog.this.tableViewer.refresh();
            }
        });
        tableColumnLayout.setColumnData((Widget)columnAuthor.getColumn(), (ColumnLayoutData)new ColumnWeightData(20));
        TableViewerColumn columnComment = new TableViewerColumn(this.tableViewer, 16384);
        columnComment.getColumn().setText("Comment");
        columnComment.getColumn().setMoveable(true);
        columnComment.setLabelProvider(new CellLabelProvider(){
            private static final long serialVersionUID = -8780127661285674313L;

            public void update(ViewerCell cell) {
                RepositoryLogEntry entry = (RepositoryLogEntry)cell.getElement();
                cell.setText(entry.getMessage());
            }
        });
        columnComment.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -6587783150487324928L;

            public void widgetSelected(SelectionEvent event) {
                ((RevisionTableViewerSorter)SelectRevisionDialog.this.tableViewer.getSorter()).doSort(3);
                SelectRevisionDialog.this.tableViewer.refresh();
            }
        });
        tableColumnLayout.setColumnData((Widget)columnComment.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        RepositoryLogEntry[] logEntries = null;
        try {
            logEntries = RepositoryItemHelper.getLogEntries(URI.createURI((String)this.item.getUri()), !this.allRevisions, "1", "-1");
        }
        catch (RepositoryAuthentificationException e) {
            throw new RuntimeException(e);
        }
        this.tableViewer.setInput((Object)logEntries);
        if (logEntries.length > 0) {
            this.tableViewer.getTable().setSelection(logEntries.length - 1);
        }
        ((RevisionTableViewerSorter)this.tableViewer.getSorter()).doSort(0);
        this.tableViewer.refresh();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    public String getSelectedRevision() {
        IStructuredSelection sSelection;
        if (this.selection instanceof IStructuredSelection && !(sSelection = (IStructuredSelection)this.selection).isEmpty()) {
            return ((RepositoryLogEntry)sSelection.getFirstElement()).getRevision();
        }
        return this.item.getRevision();
    }
}

