/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.modelbusexplorer.properties.cache;

import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.modelbus.tools.modelbusexplorer.properties.PropertyElement;

public class PropertiesCach {
    private static final Logger log = Logger.getLogger(PropertiesCach.class.getName());
    private static final BiMap<Object, PropertyElement> propertyElementCach = HashBiMap.create();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static void add(Object key, PropertyElement element) {
        lock.writeLock().lock();
        try {
            try {
                propertyElementCach.put(key, (Object)element);
            }
            catch (Exception e) {
                log.warning(e.getMessage());
                lock.writeLock().unlock();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void add(PropertyElement element) {
        PropertiesCach.add(element.hashCode(), element);
    }

    public static Optional<PropertyElement> get(Object key) {
        Optional optional;
        if (propertyElementCach.containsKey(key)) {
            lock.writeLock().lock();
            try {
                try {
                    optional = Optional.of((Object)((PropertyElement)propertyElementCach.get(key)));
                }
                catch (Exception exception) {
                    optional = Optional.absent();
                    lock.writeLock().unlock();
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        } else {
            optional = Optional.absent();
        }
        return optional;
    }

    public static void removeElementByKey(Object key) {
        lock.writeLock().lock();
        try {
            try {
                propertyElementCach.remove(key);
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
                lock.writeLock().unlock();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void updateElement(Object key, PropertyElement element) {
        lock.writeLock().lock();
        try {
            try {
                propertyElementCach.forcePut(key, (Object)element);
            }
            catch (Exception e) {
                log.warning(e.getMessage());
                lock.writeLock().unlock();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void update(PropertyElement element) {
        PropertiesCach.updateElement(element.hashCode(), element);
    }

    public static boolean isElementCached(Object key) {
        Optional<PropertyElement> optional = PropertiesCach.get(key);
        return optional.isPresent();
    }

    public static boolean isPropertyCached(PropertyElement element) {
        lock.writeLock().lock();
        boolean result = false;
        try {
            try {
                result = propertyElementCach.containsKey((Object)element.hashCode());
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
                lock.writeLock().unlock();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        return result;
    }
}

