/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.git;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FileProperties {
    public static final String FILE_EXTENSION = ".mbproperties";
    private Map<String, Map<String, String>> fileProperties;

    public FileProperties(String[] properties) {
        this.readProperties(properties);
    }

    private void readProperties(String[] properties) {
        this.fileProperties = new HashMap<String, Map<String, String>>();
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property != null && !"".equals(property)) {
                String[] propertiesDataSplitted;
                String[] chunks = property.split("::");
                String fileName = chunks[0];
                if (!this.fileProperties.containsKey(fileName)) {
                    this.fileProperties.put(fileName, new HashMap());
                }
                String[] stringArray2 = propertiesDataSplitted = chunks[1].split("\\s");
                int n3 = propertiesDataSplitted.length;
                int n4 = 0;
                while (n4 < n3) {
                    String propertyDataString = stringArray2[n4];
                    String[] propertyData = propertyDataString.split("=");
                    this.fileProperties.get(fileName).put(propertyData[0], propertyData[1]);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public String getFileProperty(String fileName, String propertyName) {
        if (!this.fileProperties.containsKey(fileName) || !this.fileProperties.get(fileName).containsKey(propertyName)) {
            return null;
        }
        return this.fileProperties.get(fileName).get(propertyName);
    }

    public void setFileProperty(String fileName, String propertyName, String propertyValue) {
        if (!this.fileProperties.containsKey(fileName)) {
            this.fileProperties.put(fileName, new HashMap());
        }
        this.fileProperties.get(fileName).put(propertyName, propertyValue);
    }

    public void save(OutputStream outStream) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outStream));
        for (String fileName : this.fileProperties.keySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(fileName).append("::");
            int i = 0;
            Set<String> propertyKeySet = this.fileProperties.get(fileName).keySet();
            for (String propertyName : propertyKeySet) {
                sb.append(propertyName).append("=").append(this.fileProperties.get(fileName).get(propertyName));
                if (i < propertyKeySet.size() - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            bw.write(sb.toString());
            bw.newLine();
        }
        bw.close();
    }
}

