/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services.api;

import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.dosgi.services.AbstractModelBusActivator;
import org.modelbus.dosgi.services.api.ModelBusServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractModelBusConsumerActivator<T>
extends AbstractModelBusActivator {
    private ModelBusServiceTracker<T> mbSt;
    private ServiceReference<T> serviceReference;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        AbstractModelBusActivator.instances.put(this.getServiceInterface().getName(), this);
        Class<T> serviceClass = this.getServiceInterface();
        System.out.println("Starting service consumer: " + serviceClass.getName());
        this.mbSt = new ModelBusServiceTracker(this);
        this.mbSt.open();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.mbSt.close();
    }

    public static final <T> AbstractModelBusConsumerActivator<T> getDefault(Class<T> serviceInterface) {
        return AbstractModelBusActivator.instances.get(serviceInterface.getName());
    }

    public final void setServiceReference(ServiceReference<T> ref) {
        this.serviceReference = ref;
        try {
            ModelBusServiceConfiguration config = this.getConfiguration();
            System.out.println("Service consumer started: " + this.getServiceInterface().getName() + ", target service at: " + config.getOption("serviceAddress"));
            this.serviceRegistered(this.getService());
        }
        catch (ModelBusServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public T getService() throws ModelBusServiceException {
        if (this.serviceReference == null) {
            throw new ModelBusServiceException("No service registered for service interface: " + this.getServiceInterface().getName());
        }
        if (this.context == null) {
            throw new ModelBusServiceException("Missing bundle context for ModelBus Service: " + this.getClass().getName());
        }
        Object svc = this.context.getService(this.serviceReference);
        Class<T> clazz = this.getServiceInterface();
        if (!clazz.isAssignableFrom(svc.getClass())) {
            throw new ModelBusServiceException("Unexpected service type for service interface: " + this.getServiceInterface().getName());
        }
        return (T)svc;
    }

    public abstract Class<T> getServiceInterface();

    protected abstract void serviceRegistered(T var1);
}

