/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.core.lib.util.DynamicEFactoryImpl;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;

public abstract class AbstractModelBusEPackageRegistry
extends EPackageRegistryImpl {
    private static final long serialVersionUID = -6941213584625635129L;
    protected final HashSet<String> nsUris = new HashSet();

    public AbstractModelBusEPackageRegistry() {
        super(EPackage.Registry.INSTANCE);
    }

    public EPackage getEPackage(String nsURI) {
        EPackage ePackage;
        if (nsURI == null) {
            return null;
        }
        if ("platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore".equals(nsURI)) {
            nsURI = "http://www.eclipse.org/emf/2002/Ecore";
        }
        if ((ePackage = super.getEPackage(nsURI)) == null) {
            URI uri = URI.createURI((String)nsURI);
            String profileLocation = "";
            boolean loaded = false;
            boolean canceled = false;
            block2: while (!loaded && !canceled) {
                if (!nsURI.contains("/schemas/") && !ModelBusCoreUtil.URIUtil.isPathMapURI(URI.createURI((String)nsURI))) {
                    if (uri.isPlatformPlugin()) {
                        uri = URI.createURI((String)uri.toString().replace("platform:/plugin/", "http://"));
                    }
                    if (!ModelBusCoreUtil.URIUtil.isHTTPURI(uri)) {
                        uri = URI.createURI((String)("http://" + uri.toString()));
                    }
                    if (super.getEPackage(uri.toString()) != null) {
                        loaded = true;
                        continue;
                    }
                    if (this.existsInRepository(uri)) {
                        if (this.isFileInRepository(uri)) {
                            loaded = true;
                            Resource resource = this.checkOutModel(uri);
                            TreeIterator iterator = resource.getAllContents();
                            while (iterator.hasNext()) {
                                EObject currentObject = (EObject)iterator.next();
                                if (!(currentObject instanceof EPackage)) continue;
                                EPackage currentPackage = (EPackage)currentObject;
                                this.registerPackage(currentPackage, uri);
                            }
                            continue;
                        }
                        if (uri.segmentCount() == 0) {
                            canceled = true;
                            continue;
                        }
                        uri = uri.trimSegments(1);
                        continue;
                    }
                    if (uri.segmentCount() == 0) {
                        canceled = true;
                        continue;
                    }
                    uri = uri.trimSegments(1);
                    continue;
                }
                profileLocation = ModelBusCoreUtil.URIUtil.isPathMapURI(URI.createURI((String)nsURI)) ? nsURI.replace("pathmap://", "http://") : (!this.existsInRepository(uri) && !ModelBusCoreUtil.URIUtil.isUMLProfileURI(uri) ? String.valueOf(uri.toString()) + ".profile.uml" : uri.toString());
                if (super.getEPackage(profileLocation) != null) {
                    loaded = true;
                    if (!ModelBusCoreUtil.URIUtil.isPathMapURI(uri)) continue;
                    uri = URI.createURI((String)profileLocation);
                    continue;
                }
                URI profileURI = URI.createURI((String)profileLocation);
                URI dirLocation = URI.createURI((String)profileLocation).trimSegments(1);
                if (this.existsInRepository(profileURI)) {
                    if (!this.isFileInRepository(profileURI)) continue;
                    loaded = true;
                    if (this.nsUris.contains(nsURI)) {
                        return null;
                    }
                    this.nsUris.add(nsURI);
                    if (ModelBusCoreUtil.URIUtil.isPathMapURI(uri)) {
                        uri = profileURI;
                    }
                    Resource resource = this.checkOutModel(profileURI);
                    TreeIterator iterator = resource.getAllContents();
                    while (iterator.hasNext()) {
                        EObject currentObject = (EObject)iterator.next();
                        if (currentObject instanceof EAnnotation) {
                            EAnnotation annotation = (EAnnotation)currentObject;
                            EList contents = annotation.getContents();
                            for (EObject eObject : contents) {
                                EObject object = eObject;
                                if (!(object instanceof EPackage)) continue;
                                this.registerPackage((EPackage)object, profileURI);
                            }
                            continue;
                        }
                        if (!(currentObject instanceof EPackage)) continue;
                        this.registerPackage((EPackage)currentObject, profileURI);
                    }
                    continue;
                }
                if (this.existsInRepository(dirLocation)) {
                    String validProfileNameWithoutExtension;
                    HashMap<String, String> validProfileNames;
                    try {
                        validProfileNames = this.getValidProfileNames(dirLocation);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    String validProfileName = URI.createURI((String)profileLocation).lastSegment();
                    int index = validProfileName.indexOf(".profile");
                    if (index == -1) {
                        index = validProfileName.indexOf(".epx");
                    }
                    if (validProfileNames.containsValue(validProfileNameWithoutExtension = validProfileName.substring(0, index))) {
                        Set<Map.Entry<String, String>> set = validProfileNames.entrySet();
                        for (Map.Entry<String, String> entry : set) {
                            if (!validProfileNameWithoutExtension.equals(entry.getValue())) continue;
                            String profileName = entry.getKey();
                            uri = URI.createURI((String)profileLocation).trimSegments(1).appendSegment(profileName);
                            continue block2;
                        }
                        continue;
                    }
                    canceled = true;
                    continue;
                }
                if (uri.segmentCount() == 0) {
                    canceled = true;
                    continue;
                }
                uri = uri.trimSegments(1);
            }
            if (loaded) {
                ePackage = super.getEPackage(nsURI.toString());
            }
        }
        return ePackage;
    }

    protected void registerPackage(EPackage ePackage, URI metamodelRepositoryURI) {
        if (!(ePackage.getEFactoryInstance() instanceof DynamicEFactoryImpl)) {
            ePackage.setEFactoryInstance((EFactory)new DynamicEFactoryImpl());
        }
        String pkgNsURI = ePackage.getNsURI();
        this.put(pkgNsURI, ePackage);
        if (!metamodelRepositoryURI.isPlatform() && ePackage.getESuperPackage() == null && !pkgNsURI.equals(metamodelRepositoryURI.toString())) {
            this.put(metamodelRepositoryURI.toString(), ePackage);
        }
    }

    protected HashMap<String, String> getValidProfileNames(URI dirLocation) throws InvalidRevisionException, NonExistingResourceException {
        HashMap<String, String> validProfileNames = new HashMap<String, String>();
        ArrayList<String> invalidProfileNames = new ArrayList<String>();
        List<String> entries = this.getDirEntryNames(dirLocation);
        Iterator<String> iterator = entries.iterator();
        while (iterator.hasNext()) {
            String string;
            String modelBusDirEntryName = string = iterator.next();
            String profileNameWithoutExtension = "";
            if (modelBusDirEntryName.endsWith(".profile.uml")) {
                profileNameWithoutExtension = modelBusDirEntryName.substring(0, modelBusDirEntryName.indexOf(".profile"));
                invalidProfileNames.add(profileNameWithoutExtension);
                continue;
            }
            if (!modelBusDirEntryName.endsWith(".epx")) continue;
            profileNameWithoutExtension = modelBusDirEntryName.substring(0, modelBusDirEntryName.indexOf(".epx"));
            invalidProfileNames.add(profileNameWithoutExtension);
        }
        if (!invalidProfileNames.isEmpty()) {
            for (String name : invalidProfileNames) {
                StringBuffer validJavaIdentifier = new StringBuffer();
                char char_0 = name.charAt(0);
                if (Character.isJavaIdentifierStart(char_0)) {
                    validJavaIdentifier.append(char_0);
                }
                int i = 1;
                while (i < name.length()) {
                    char char_i = name.charAt(i);
                    if (Character.isJavaIdentifierPart(char_i)) {
                        validJavaIdentifier.append(char_i);
                    }
                    ++i;
                }
                validProfileNames.put(name, validJavaIdentifier.toString());
            }
        }
        return validProfileNames;
    }

    protected abstract boolean existsInRepository(URI var1);

    protected abstract boolean isFileInRepository(URI var1);

    protected abstract Resource checkOutModel(URI var1);

    protected abstract List<String> getDirEntryNames(URI var1);
}

