/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.types;

public enum UnaryOperatorType {
    INC,
    DEC;


    public static UnaryOperatorType asOperator(String text) {
        if ("++".equals(text)) {
            return INC;
        }
        if ("--".equals(text)) {
            return DEC;
        }
        throw new IllegalArgumentException("Operator not supported: " + text);
    }

    public String getOperatorText(UnaryOperatorType operator) {
        if (operator == INC) {
            return "++";
        }
        if (operator == DEC) {
            return "--";
        }
        return "";
    }

    public String toString() {
        return this.getOperatorText(this);
    }
}

