/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.match;

import org.modelbus.tools.diffmerge.match.DefaultMatchengineFactoryProvider;
import org.modelbus.tools.diffmerge.match.MatchEngineFactoryProvider;
import org.modelbus.tools.diffmerge.match.Matcher;
import org.modelbus.tools.diffmerge.match.MatcherImpl;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;

public class MatcherBuilder {
    private MatchEngineFactoryProvider provider;
    private final ModelIdentifier identifier;
    private int priority = 20;

    public MatcherBuilder(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public Matcher build() {
        MatchEngineFactoryProvider prov = this.getProvider();
        return new MatcherImpl(this.priority, this.identifier, prov);
    }

    private MatchEngineFactoryProvider getProvider() {
        if (this.provider == null) {
            this.provider = new DefaultMatchengineFactoryProvider();
        }
        return this.provider;
    }

    public MatcherBuilder setMatchEngineFactoryProvider(MatchEngineFactoryProvider provider) {
        this.provider = provider;
        return this;
    }

    public MatcherBuilder setFactoryPriority(int priority) {
        this.priority = priority;
        return this;
    }
}

