/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.diff;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelContentProvider;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelElementSelectedEvent;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelLabelProvider;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelViewEventHandler;
import org.modelbus.tools.diffmerge.ui.icon.IconProvider;
import org.modelbus.tools.diffmerge.ui.util.GuiHelperUtil;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class DiffModelView
extends Composite
implements EventBusParticipant {
    private TreeViewer treeViewer;
    private static final int BUTTON_WIDTH = 70;
    private final ModelBusEventBus eventBus;
    private final GuiHelperUtil guiUtil;
    private final UIConfig config;
    private final Collection<Object> evenHandlers = Lists.newLinkedList();
    private final IconProvider modelIconProvider;

    public DiffModelView(Composite parent, int style, ModelBusEventBus eventBus, GuiHelperUtil guiUtil, IconProvider modelIconProvider, UIConfig config) {
        super(parent, style);
        this.eventBus = eventBus;
        this.guiUtil = guiUtil;
        this.config = config;
        this.modelIconProvider = modelIconProvider;
        this.initUI();
        DiffModelViewEventHandler handler = new DiffModelViewEventHandler(this.treeViewer);
        this.evenHandlers.add(handler);
    }

    private void initUI() {
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new RowLayout(256));
        this.addCollapseButton(buttonContainer);
        this.addExpandButton(buttonContainer);
        this.createTreeViewer(composite);
    }

    private void addExpandButton(Composite buttonContainer) {
        Button buttonExpand = new Button(buttonContainer, 0);
        buttonExpand.setLayoutData((Object)new RowData(70, -1));
        buttonExpand.setText("Expand");
        buttonExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffModelView.this.treeViewer.expandAll();
            }
        });
    }

    private void addCollapseButton(Composite buttonContainer) {
        Button buttonCollapse = new Button(buttonContainer, 0);
        buttonCollapse.setLayoutData((Object)new RowData(70, -1));
        buttonCollapse.setText("Collapse");
        buttonCollapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffModelView.this.treeViewer.collapseAll();
            }
        });
    }

    private void createTreeViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 0x10000800);
        this.treeViewer.setContentProvider((IContentProvider)new DiffModelContentProvider());
        DiffModelLabelProvider labelProvider = new DiffModelLabelProvider(this.guiUtil, this.modelIconProvider, this.config);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                DiffModelElement element = (DiffModelElement)selection.getFirstElement();
                if (element != null) {
                    DiffModelView.this.eventBus.post((Object)new DiffModelElementSelectedEvent(element));
                }
            }
        });
        this.evenHandlers.add((Object)labelProvider);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tree.setBounds(10, 46, 440, 218);
        this.treeViewer.setUseHashlookup(true);
    }

    protected void checkSubclass() {
    }

    public Collection<Object> getAllEventHandlers() {
        return this.evenHandlers;
    }

    public ModelBusEventBus getEventBus() {
        throw new RuntimeException("Not supported");
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Not supported");
    }
}

