/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.notification.provider.cxf.impl;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.modelbus.repositorynotification.RepositoryNotification;

public class SimpleRepositoryNotification
implements RepositoryNotification {
    private static final String TOPIC_NAME = "RepositoryNotification";
    private static final String PROPERTY_IS_FAULT = "SOAPJMS_isFault";
    private static final String PROPERTY_BINDING_VERSION = "SOAPJMS_bindingVersion";
    private static final String PROPERTY_CONTENT_TYPE = "SOAPJMS_contentType";
    private static final String PROPERTY_REQUESTED_URI = "SOAPJMS_requestURI";
    private static final String PROPERTY_SOAP_ACTION = "SOAPJMS_soapAction";
    private static final String DELETE_MSG_TEMPLATE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:deleteModel xmlns:ns2=\"http://www.modelbus.org/RepositoryNotification/\"><modelUri>{0}</modelUri><userName>{1}</userName><sessionID>{2}</sessionID></ns2:deleteModel></soap:Body></soap:Envelope>";
    private static final MessageFormat DELETE_MSG_FORMAT = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:deleteModel xmlns:ns2=\"http://www.modelbus.org/RepositoryNotification/\"><modelUri>{0}</modelUri><userName>{1}</userName><sessionID>{2}</sessionID></ns2:deleteModel></soap:Body></soap:Envelope>");
    private static final String CREATE_MSG_TEMPLATE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:createModel xmlns:ns2=\"http://www.modelbus.org/RepositoryNotification/\"><modelUri>{0}</modelUri><userName>{1}</userName><sessionID>{2}</sessionID></ns2:createModel></soap:Body></soap:Envelope>";
    private static final MessageFormat CREATE_MSG_FORMAT = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:createModel xmlns:ns2=\"http://www.modelbus.org/RepositoryNotification/\"><modelUri>{0}</modelUri><userName>{1}</userName><sessionID>{2}</sessionID></ns2:createModel></soap:Body></soap:Envelope>");
    private static final String UPDATE_MSG_TEMPLATE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:updateModel xmlns:ns2=\"http://www.modelbus.org/RepositoryNotification/\"><modelUri>{0}</modelUri><userName>{1}</userName><sessionID>{2}</sessionID></ns2:updateModel></soap:Body></soap:Envelope>";
    private static final MessageFormat UPDATE_MSG_FORMAT = new MessageFormat("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns2:updateModel xmlns:ns2=\"http://www.modelbus.org/RepositoryNotification/\"><modelUri>{0}</modelUri><userName>{1}</userName><sessionID>{2}</sessionID></ns2:updateModel></soap:Body></soap:Envelope>");
    private final Connection connection;
    private final Session session;
    private final Topic repositoryNotificationTopic;

    public SimpleRepositoryNotification(String notificationLocation) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(notificationLocation);
        this.connection = factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.repositoryNotificationTopic = this.session.createTopic(TOPIC_NAME);
    }

    public void createModel(String modelUri, String userName, String sessionID) {
        String msg = CREATE_MSG_FORMAT.format(new Object[]{modelUri, userName, sessionID});
        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
        try {
            MessageProducer producer = this.session.createProducer((Destination)this.repositoryNotificationTopic);
            BytesMessage jmsMessage = this.createMessage("createModel");
            jmsMessage.clearBody();
            jmsMessage.writeBytes(msgBytes);
            producer.send((Message)jmsMessage);
            producer.close();
        }
        catch (JMSException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void deleteModel(String modelUri, String userName, String sessionID) {
        String msg = DELETE_MSG_FORMAT.format(new Object[]{modelUri, userName, sessionID});
        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
        try {
            MessageProducer producer = this.session.createProducer((Destination)this.repositoryNotificationTopic);
            BytesMessage jmsMessage = this.createMessage("deleteModel");
            jmsMessage.clearBody();
            jmsMessage.writeBytes(msgBytes);
            producer.send((Message)jmsMessage);
            producer.close();
        }
        catch (JMSException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void updateModel(String modelUri, String userName, String sessionID) {
        String msg = UPDATE_MSG_FORMAT.format(new Object[]{modelUri, userName, sessionID});
        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
        try {
            MessageProducer producer = this.session.createProducer((Destination)this.repositoryNotificationTopic);
            BytesMessage jmsMessage = this.createMessage("updateModel");
            jmsMessage.clearBody();
            jmsMessage.writeBytes(msgBytes);
            producer.send((Message)jmsMessage);
            producer.close();
        }
        catch (JMSException exc) {
            throw new RuntimeException(exc);
        }
    }

    private BytesMessage createMessage(String actionName) throws JMSException {
        BytesMessage jmsMessage = this.session.createBytesMessage();
        jmsMessage.setBooleanProperty(PROPERTY_IS_FAULT, false);
        jmsMessage.setStringProperty(PROPERTY_BINDING_VERSION, "1.0");
        jmsMessage.setStringProperty(PROPERTY_REQUESTED_URI, "jms:topic:RepositoryNotification");
        jmsMessage.setStringProperty(PROPERTY_CONTENT_TYPE, "text/xml; charset=UTF-8");
        jmsMessage.setStringProperty(PROPERTY_SOAP_ACTION, "\"http://www.modelbus.org/RepositoryNotification/" + actionName + "\"");
        return jmsMessage;
    }

    public void close() throws JMSException {
        this.session.close();
        this.connection.close();
    }
}

