/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.compare;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.compare.ModelCompareEditorInput;
import org.modelbus.dosgi.repository.descriptor.Session;
import org.modelbus.tools.diffmerge.DiffMerge;
import org.modelbus.tools.diffmerge.config.DiffMergeConfig;
import org.modelbus.tools.diffmerge.controller.IDiffMergeController;
import org.modelbus.tools.diffmerge.engine.DiffMergeEngine;
import org.modelbus.tools.diffmerge.engine.DiffMergeUMLEngine;
import org.modelbus.tools.diffmerge.exceptionhandler.DiffMergeException;
import org.modelbus.tools.diffmerge.gui.IDiffMergeView;

public class CompareEditor
extends EditorPart {
    public static final String ID = "org.modelbus.desktop.CompareEditor";
    private IDiffMergeController mergeCtrl;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (input == null || !(input instanceof ModelCompareEditorInput)) {
            throw new IllegalArgumentException("DiffEditor requires editor input of type " + ModelCompareEditorInput.class.getName());
        }
        this.setInput(input);
    }

    public void createPartControl(Composite parent) {
        IEditorInput input = this.getEditorInput();
        parent.setLayout((Layout)new FillLayout(256));
        ModelCompareEditorInput editorInput = (ModelCompareEditorInput)input;
        this.setTitle(editorInput.getName());
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", UMLResource.Factory.INSTANCE);
        rs.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource currentResource = rs.createResource(URI.createURI((String)editorInput.getLeft().getUri()));
        Resource compareResource = rs.createResource(URI.createURI((String)editorInput.getRight().getUri()));
        resources.add(currentResource);
        resources.add(compareResource);
        Session session = UserSessionHelper.getInstance().getSession();
        if (session == null) {
            throw new RuntimeException("Login required");
        }
        try {
            ModelBusCoreLib.getRepositoryHelper().checkOutModelWithRevision(session, currentResource, editorInput.getLeft().getRevision(), Collections.EMPTY_MAP);
            ModelBusCoreLib.getRepositoryHelper().checkOutModelWithRevision(session, compareResource, editorInput.getRight().getRevision(), Collections.EMPTY_MAP);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        DiffMergeUMLEngine umlModel = new DiffMergeUMLEngine();
        this.mergeCtrl = DiffMerge.createNewControllerForDiffMergeEngine((DiffMergeEngine)umlModel);
        IDiffMergeView diffView = DiffMerge.createNewDiffMergeView((IDiffMergeController)this.mergeCtrl, (Composite)parent);
        DiffMergeConfig cfg = diffView.getDiffMergeConfig();
        cfg.hideAllButtons();
        cfg.setShowCancelButton(false);
        cfg.setShowMergeButton(false);
        cfg.setShowOkButton(false);
        cfg.setShowSolveButton(false);
        cfg.update();
        this.mergeCtrl.setLocalModelResource(currentResource);
        this.mergeCtrl.setRemoteModelResource(compareResource);
        try {
            this.mergeCtrl.compare();
        }
        catch (DiffMergeException e) {
            throw new RuntimeException(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }
}

