/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.gui.impl;

import java.util.Collection;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.modelbus.tools.diffmerge.config.ConfigChangedListener;
import org.modelbus.tools.diffmerge.config.DiffMergeConfig;
import org.modelbus.tools.diffmerge.config.IDiffMergeConfig;
import org.modelbus.tools.diffmerge.gui.IDiffMergeView;
import org.modelbus.tools.diffmerge.ui.DiffMergeView;
import org.modelbus.tools.diffmerge.ui.config.UIButtonConfig;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class DiffMergeViewImpl
implements IDiffMergeView,
ConfigChangedListener {
    private final DiffMergeView view;
    private final UIConfig uiConfig;
    private final UIButtonConfig buttonConfig;
    private final DiffMergeConfig config;
    private boolean isUpdated = false;

    public DiffMergeViewImpl(DiffMergeView view, DiffMergeConfig config) {
        this.view = view;
        this.uiConfig = view.getConfig();
        this.buttonConfig = view.getConfig().getButtonConfig();
        this.config = config;
        this.config.addConfigChangedListener(this);
        this.addListener();
    }

    private void addListener() {
        ((Control)this.view).getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (!DiffMergeViewImpl.this.isUpdated) {
                    DiffMergeViewImpl.this.buttonConfig.update();
                    DiffMergeViewImpl.this.isUpdated = true;
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return (Control)this.view;
    }

    @Override
    public void setDiffMergeConfig(IDiffMergeConfig config) {
        this.okButtonChanged(config.showOkButton());
        this.cancelButtonChanged(config.showCancelButton());
    }

    @Override
    public void okButtonChanged(boolean showButton) {
        this.isUpdated = false;
        if (showButton) {
            this.buttonConfig.showOkButton();
        } else {
            this.buttonConfig.hideOkButton();
        }
    }

    @Override
    public void cancelButtonChanged(boolean showButton) {
        this.isUpdated = false;
        if (showButton) {
            this.buttonConfig.showCancelButton();
        } else {
            this.buttonConfig.hideCancelButton();
        }
    }

    @Override
    public void editingSupportChanged(boolean enable) {
        this.view.getConfig().setEditingSupportEnabled(enable).update();
    }

    @Override
    public void updateButtonChanged(boolean showButton) {
        this.isUpdated = false;
        if (showButton) {
            this.buttonConfig.showUpdateButton();
        } else {
            this.buttonConfig.hideUpdateButton();
        }
    }

    @Override
    public void commitButtonChanged(boolean showButton) {
        this.isUpdated = false;
        if (showButton) {
            this.buttonConfig.showCommitButton();
        } else {
            this.buttonConfig.hideCommitButtion();
        }
    }

    @Override
    public void mergeButtonChanged(boolean showButton) {
        this.isUpdated = false;
        if (showButton) {
            this.buttonConfig.showMergeButton();
        } else {
            this.buttonConfig.hideMergeButton();
        }
    }

    @Override
    public void solveButtonChanged(boolean showButton) {
        this.isUpdated = false;
        if (showButton) {
            this.buttonConfig.showSolveButton();
        } else {
            this.buttonConfig.hideSolveButton();
        }
    }

    @Override
    public DiffMergeConfig getDiffMergeConfig() {
        return this.config;
    }

    @Override
    public void dispose() {
        Collection allEventHandlers = this.view.getAllEventHandlers();
        ModelBusEventBus eventBus = this.view.getEventBus();
        for (Object handler : allEventHandlers) {
            eventBus.unregister(handler);
        }
    }

    @Override
    public void update() {
        this.buttonConfig.update();
    }

    @Override
    public void showAllButtonsChanged(boolean showAllButtons) {
        if (showAllButtons) {
            this.showAllButtons();
        } else {
            this.hideAllButtons();
        }
    }

    private void hideAllButtons() {
        this.uiConfig.setNoActionMode();
        this.uiConfig.update();
    }

    private void showAllButtons() {
        this.uiConfig.setSynchronizeMode();
        this.uiConfig.update();
    }
}

