/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.config.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.modelbus.tools.diffmerge.config.ConfigChangedListener;
import org.modelbus.tools.diffmerge.config.DiffMergeConfig;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public class DiffMergeConfigImpl
implements DiffMergeConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DiffMergeConfigImpl.class);
    private boolean okButton;
    private boolean cancelButton;
    private boolean commitButton;
    private boolean updateButton;
    private final Set<ConfigChangedListener> listeners = Sets.newHashSet();
    private boolean solveButton;
    private boolean mergeButton;
    private boolean editingSupport;

    @Override
    public void setShowOkButton(boolean value) {
        this.okButton = value;
        this.notifyAllListener("okButtonChanged", value);
    }

    private void notifyAllListener(String methodName, boolean value) {
        Method method = null;
        if (this.listeners.isEmpty()) {
            LOG.info("No ConfigListeners registered");
        }
        for (ConfigChangedListener listener : this.listeners) {
            if (method == null && (method = this.getMethod(listener, methodName, Boolean.TYPE)) == null) {
                LOG.error(String.format("Cancel listener notification! No method %s found at listener %s.", methodName, listener.getClass().getName()));
                return;
            }
            this.notifyListener(listener, method, value);
        }
    }

    private Method getMethod(ConfigChangedListener listener, String methodName, Class<?> ... values) {
        Method method = null;
        try {
            method = listener.getClass().getDeclaredMethod(methodName, values);
        }
        catch (SecurityException e) {
            LOG.error(String.format("Excpetion: %s\nMessage: %s", e.getClass().getSimpleName(), e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            LOG.error(String.format("Excpetion: %s\nMessage: %s", e.getClass().getSimpleName(), e.getMessage()));
        }
        return method;
    }

    /*
     * Loose catch block
     */
    private Optional<Object> notifyListener(ConfigChangedListener listener, Method method, boolean value) {
        Optional result;
        block8: {
            Object returnValue = null;
            try {
                returnValue = method.invoke((Object)listener, value);
            }
            catch (IllegalArgumentException e) {
                LOG.error(String.format("Excpetion: %s\nMessage: %s", e.getClass().getSimpleName(), e.getMessage()));
                result = Optional.fromNullable((Object)returnValue);
                break block8;
            }
            catch (IllegalAccessException e) {
                LOG.error(String.format("Excpetion: %s\nMessage: %s", e.getClass().getSimpleName(), e.getMessage()));
                result = Optional.fromNullable((Object)returnValue);
                break block8;
            }
            catch (InvocationTargetException e) {
                LOG.error(String.format("Excpetion: %s\nMessage: %s", e.getClass().getSimpleName(), e.getMessage()));
                {
                    catch (Throwable throwable) {
                        Optional result2 = Optional.fromNullable(returnValue);
                        throw throwable;
                    }
                }
                result = Optional.fromNullable((Object)returnValue);
                break block8;
            }
            result = Optional.fromNullable((Object)returnValue);
        }
        return result;
    }

    @Override
    public void setShowPropertyTab(boolean value) {
    }

    @Override
    public boolean showOkButton() {
        return this.okButton;
    }

    @Override
    public void setShowCancelButton(boolean value) {
        this.cancelButton = value;
        this.notifyAllListener("cancelButtonChanged", value);
    }

    @Override
    public boolean showCancelButton() {
        return this.cancelButton;
    }

    @Override
    public void addConfigChangedListener(ConfigChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setShowCommitButton(boolean value) {
        this.commitButton = value;
        this.notifyAllListener("commitButtonChanged", value);
    }

    @Override
    public boolean showCommitButton() {
        return this.commitButton;
    }

    @Override
    public void setEnableEditingSupport(boolean value) {
        this.editingSupport = value;
        this.notifyAllListener("editingSupportChanged", value);
    }

    @Override
    public boolean isEnableEditingSupport() {
        return this.editingSupport;
    }

    @Override
    public void setShowUpdateButton(boolean value) {
        this.updateButton = value;
        this.notifyAllListener("updateButtonChanged", value);
    }

    @Override
    public boolean showUpdateButton() {
        return this.updateButton;
    }

    @Override
    public void setShowSolveButton(boolean value) {
        this.solveButton = value;
        this.notifyAllListener("solveButtonChanged", value);
    }

    @Override
    public boolean showSolveButton() {
        return this.solveButton;
    }

    @Override
    public void setShowMergeButton(boolean value) {
        this.mergeButton = value;
        this.notifyAllListener("mergeButtonChanged", value);
    }

    @Override
    public boolean showMergeButton() {
        return this.mergeButton;
    }

    @Override
    public void hideAllButtons() {
        this.notifyAllListener("showAllButtonsChanged", false);
    }

    public void showAllButtons() {
        this.notifyAllListener("showAllButtonsChanged", true);
    }

    @Override
    public void update() {
        for (ConfigChangedListener listener : this.listeners) {
            listener.update();
        }
    }
}

