/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.icon;

import com.google.common.base.Optional;
import java.io.InputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.modelbus.tools.diffmerge.ui.icon.AbstractIconProvider;

public class EcoreIconProvider
extends AbstractIconProvider {
    public static final String RESOURCE_URL = "/org/modelbus/tools/diffmerge/icons/ecore/";

    public EcoreIconProvider(Display display) {
        super(display);
    }

    @Override
    public Image getIconForModelElement(Object element) {
        if (!(element instanceof EObject)) {
            return null;
        }
        EObject modelElement = (EObject)element;
        String name = modelElement.eClass().getName();
        String iconLocation = this.getIconLocationOfClass(name);
        Optional<Image> cachedIcon = this.getCachedIcon(iconLocation);
        if (cachedIcon.isPresent()) {
            return (Image)cachedIcon.get();
        }
        return this.createNewIcon(iconLocation);
    }

    private Image createNewIcon(String iconLocation) {
        Optional<InputStream> stream = this.getImageAsStream(iconLocation);
        if (stream.isPresent()) {
            Image icon = this.createImage((InputStream)stream.get());
            this.cachIcon(iconLocation, icon);
            return icon;
        }
        return this.getDefaultImage();
    }

    protected String getIconLocationOfClass(String className) {
        return RESOURCE_URL + className + ".gif";
    }
}

