/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.model;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelElementSelectedEvent;
import org.modelbus.tools.diffmerge.ui.model.ModelView;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.diffmerge2.joint.event.DiffModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.LeftModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.RightModelChangedEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;

class ModelCompareViewEventHandler
implements EventBusParticipant {
    private final ModelView localTabFolder;
    private final ModelView remoteTabFolder;
    private Notifier rightInput;
    private Notifier leftInput;
    private final ModelBusEventBus eventBus;

    ModelCompareViewEventHandler(ModelBusEventBus eventBus, ModelView leftFolder, ModelView rightFolder) {
        this.localTabFolder = leftFolder;
        this.remoteTabFolder = rightFolder;
        this.eventBus = eventBus;
    }

    @Handler
    public void diffModelElementSelectedEventHandler(DiffModelElementSelectedEvent event) {
        EObject rightElement;
        EObject leftElement;
        DiffModelElement element = event.getElement();
        if (element instanceof DiffModel) {
            leftElement = this.localTabFolder.getModel();
            rightElement = this.remoteTabFolder.getModel();
        } else {
            leftElement = element.getLeftElement();
            rightElement = element.getRightElement();
        }
        if (leftElement != null) {
            this.localTabFolder.selectElement(leftElement);
        }
        if (rightElement != null) {
            this.remoteTabFolder.selectElement(rightElement);
        }
    }

    @Handler
    public void leftModelInputChangedEventHandler(LeftModelChangedEvent event) {
        Notifier input;
        this.leftInput = input = event.getInput();
        this.localTabFolder.setModel(this.leftInput);
    }

    @Handler
    public void rightModelInputChangedEventHandler(RightModelChangedEvent event) {
        Notifier input;
        this.rightInput = input = event.getInput();
        this.remoteTabFolder.setModel(this.rightInput);
    }

    @Handler
    public void diffModelChangedEventHandler(DiffModelChangedEvent event) {
        if (this.rightInput != null) {
            this.remoteTabFolder.refreshView();
        }
        if (this.leftInput != null) {
            this.localTabFolder.refreshView();
        }
    }

    public Collection<Object> getAllEventHandlers() {
        return Sets.newHashSet((Object[])new Object[]{this});
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Operation not supported");
    }
}

