/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.Activator;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTopologyManager {
    public static final String SERVICE_EXPORTED_INTERFACES_WILDCARD = "*";
    private BundleContext context;
    private ServiceTracker<IServiceInfoFactory, IServiceInfoFactory> serviceInfoFactoryTracker;
    private ServiceTracker remoteServiceAdminTracker;
    private Object remoteServiceAdminTrackerLock = new Object();
    private final Map<org.osgi.service.remoteserviceadmin.EndpointDescription, List<ServiceRegistration<IServiceInfo>>> registrations = new HashMap<org.osgi.service.remoteserviceadmin.EndpointDescription, List<ServiceRegistration<IServiceInfo>>>();
    private final ReentrantLock registrationLock;
    private boolean requireServiceExportedConfigs = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager.requireServiceExportedConfigs", "false"));

    public AbstractTopologyManager(BundleContext context) {
        this.serviceInfoFactoryTracker = new ServiceTracker(context, this.createISIFFilter(context), null);
        this.serviceInfoFactoryTracker.open();
        this.context = context;
        this.registrationLock = new ReentrantLock(true);
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected String getFrameworkUUID() {
        Activator a = Activator.getDefault();
        if (a == null) {
            return null;
        }
        return a.getFrameworkUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.registrationLock.lock();
        try {
            for (org.osgi.service.remoteserviceadmin.EndpointDescription ed : this.registrations.keySet()) {
                this.unadvertiseEndpointDescription(ed);
            }
            this.registrations.clear();
        }
        finally {
            this.registrationLock.unlock();
        }
        Object object = this.remoteServiceAdminTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminTracker != null) {
                this.remoteServiceAdminTracker.close();
                this.remoteServiceAdminTracker = null;
            }
        }
        this.context = null;
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected Filter createRSAFilter() {
        String filterString = "(&(objectClass=" + org.osgi.service.remoteserviceadmin.RemoteServiceAdmin.class.getName() + ")(" + "org.eclipse.ecf.rsa" + "=*))";
        try {
            return this.getContext().createFilter(filterString);
        }
        catch (InvalidSyntaxException doesNotHappen) {
            doesNotHappen.printStackTrace();
            return null;
        }
    }

    protected Filter createISIFFilter(BundleContext ctx) {
        String filterString = "(objectClass=" + IServiceInfoFactory.class.getName() + ")";
        try {
            return ctx.createFilter(filterString);
        }
        catch (InvalidSyntaxException doesNotHappen) {
            doesNotHappen.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.osgi.service.remoteserviceadmin.RemoteServiceAdmin getRemoteServiceAdmin() {
        Object object = this.remoteServiceAdminTrackerLock;
        synchronized (object) {
            if (this.remoteServiceAdminTracker == null) {
                this.remoteServiceAdminTracker = new ServiceTracker(Activator.getContext(), this.createRSAFilter(), null);
                this.remoteServiceAdminTracker.open();
            }
        }
        return (org.osgi.service.remoteserviceadmin.RemoteServiceAdmin)this.remoteServiceAdminTracker.getService();
    }

    private void addRegistration(org.osgi.service.remoteserviceadmin.EndpointDescription ed, ServiceRegistration<IServiceInfo> reg) {
        List<ServiceRegistration<IServiceInfo>> regs = this.registrations.get(ed);
        if (regs == null) {
            regs = new ArrayList<ServiceRegistration<IServiceInfo>>();
        }
        regs.add(reg);
        this.registrations.put(ed, regs);
    }

    protected void advertiseModifyEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.registrationLock.lock();
        try {
            IServiceInfoFactory service = (IServiceInfoFactory)this.serviceInfoFactoryTracker.getService();
            if (service != null) {
                IServiceInfo serviceInfo = service.createServiceInfo(null, endpointDescription);
                if (serviceInfo != null) {
                    this.trace("advertiseModifyEndpointDescription", "advertising modify endpointDescription=" + endpointDescription + " and IServiceInfo " + serviceInfo);
                    ServiceRegistration registerService = this.context.registerService(IServiceInfo.class, (Object)serviceInfo, null);
                    this.addRegistration(endpointDescription, (ServiceRegistration<IServiceInfo>)registerService);
                } else {
                    this.logError("advertiseModifyEndpointDescription", "IServiceInfoFactory failed to convert EndpointDescription " + endpointDescription);
                }
            } else {
                this.logError("advertiseModifyEndpointDescription", "no IServiceInfoFactory service found");
            }
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    protected void advertiseEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.registrationLock.lock();
        try {
            if (this.registrations.containsKey(endpointDescription)) {
                return;
            }
            IServiceInfoFactory service = (IServiceInfoFactory)this.serviceInfoFactoryTracker.getService();
            if (service != null) {
                IServiceInfo serviceInfo = service.createServiceInfo(null, endpointDescription);
                if (serviceInfo != null) {
                    this.trace("advertiseEndpointDescription", "advertising endpointDescription=" + endpointDescription + " and IServiceInfo " + serviceInfo);
                    ServiceRegistration registerService = this.context.registerService(IServiceInfo.class, (Object)serviceInfo, null);
                    this.addRegistration(endpointDescription, (ServiceRegistration<IServiceInfo>)registerService);
                } else {
                    this.logError("advertiseEndpointDescription", "IServiceInfoFactory failed to convert EndpointDescription " + endpointDescription);
                }
            } else {
                this.logError("advertiseEndpointDescription", "no IServiceInfoFactory service found");
            }
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    protected void unadvertiseEndpointDescription(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.registrationLock.lock();
        try {
            List<ServiceRegistration<IServiceInfo>> serviceRegistrations = this.registrations.remove(endpointDescription);
            if (serviceRegistrations != null) {
                for (ServiceRegistration<IServiceInfo> serviceRegistration : serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                return;
            }
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    protected void logError(String methodName, String message, Throwable exception) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message, exception);
    }

    protected void logError(String methodName, String message, IStatus result) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), result);
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", this.getClass(), message);
    }

    protected void handleECFEndpointAdded(EndpointDescription endpointDescription) {
        this.trace("handleECFEndpointAdded", "endpointDescription=" + (Object)((Object)endpointDescription));
        RemoteServiceAdmin rsa = (RemoteServiceAdmin)this.getRemoteServiceAdmin();
        if (rsa != null) {
            rsa.importService(endpointDescription);
        }
    }

    protected void handleECFEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("handleECFEndpointRemoved", "endpointDescription=" + endpointDescription);
        RemoteServiceAdmin rsa = (RemoteServiceAdmin)this.getRemoteServiceAdmin();
        if (rsa != null) {
            List<RemoteServiceAdmin.ImportRegistration> importedRegistrations = rsa.getImportedRegistrations();
            EndpointDescription ed = (EndpointDescription)endpointDescription;
            for (RemoteServiceAdmin.ImportRegistration importedRegistration : importedRegistrations) {
                if (!importedRegistration.match(ed)) continue;
                this.trace("handleEndpointRemoved", "closing importedRegistration=" + importedRegistration);
                importedRegistration.close();
            }
        }
    }

    protected void handleECFEndpointModified(EndpointDescription endpoint) {
        this.trace("handleECFEndpointModified", "endpointDescription=" + (Object)((Object)endpoint));
        RemoteServiceAdmin rsa = (RemoteServiceAdmin)this.getRemoteServiceAdmin();
        if (rsa != null) {
            List<RemoteServiceAdmin.ImportRegistration> importedRegistrations = rsa.getImportedRegistrations();
            EndpointDescription ed = endpoint;
            for (RemoteServiceAdmin.ImportRegistration importedRegistration : importedRegistrations) {
                if (!importedRegistration.match(ed)) continue;
                this.trace("handleECFEndpointModified", "updating importedRegistration=" + importedRegistration);
                importedRegistration.update(endpoint);
            }
        }
    }

    protected void handleNonECFEndpointAdded(EndpointListener listener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("handleNonECFEndpointAdded", "ed=" + endpointDescription);
    }

    protected void handleNonECFEndpointRemoved(EndpointListener listener, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("handleNonECFEndpointRemoved", "ed=" + endpointDescription);
    }

    protected void handleNonECFEndpointModified(EndpointEventListener basicTopologyManagerImpl, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        this.trace("handleNonECFEndpointModified", "ed=" + endpointDescription);
    }

    protected void handleNonECFEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, String matchedFilter) {
        this.advertiseEndpointDescription(endpointDescription);
    }

    protected void handleAdvertisingResult(IStatus result, org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, boolean advertise) {
        if (!result.isOK()) {
            this.logError("handleAdvertisingResult", String.valueOf(advertise ? "Advertise" : "Unadvertise") + " of endpointDescription=" + endpointDescription + " FAILED", result);
        }
    }

    protected void handleInvalidImportRegistration(ImportRegistration importRegistration, Throwable t) {
        this.logError("handleInvalidImportRegistration", "importRegistration=" + importRegistration, t);
    }

    protected void handleEvent(ServiceEvent event, Map listeners) {
        switch (event.getType()) {
            case 2: {
                this.handleServiceModifying(event.getServiceReference());
                break;
            }
            case 1: {
                this.handleServiceRegistering(event.getServiceReference());
                break;
            }
        }
    }

    protected void handleServiceRegistering(ServiceReference serviceReference) {
        String[] exportedInterfaces = PropertiesUtil.getExportedInterfaces(serviceReference);
        if (exportedInterfaces == null) {
            return;
        }
        String[] serviceExportedConfigs = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.configs"));
        if (this.requireServiceExportedConfigs && (serviceExportedConfigs == null || Arrays.asList(serviceExportedConfigs).size() == 0)) {
            return;
        }
        TreeMap<String, String[]> exportProperties = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        exportProperties.put("service.exported.interfaces", exportedInterfaces);
        this.trace("handleServiceRegistering", "serviceReference=" + serviceReference + " exportProperties=" + exportProperties);
        org.osgi.service.remoteserviceadmin.RemoteServiceAdmin rsa = this.getRemoteServiceAdmin();
        if (rsa != null) {
            rsa.exportService(serviceReference, exportProperties);
        }
    }

    protected void handleServiceModifying(ServiceReference serviceReference) {
        RemoteServiceAdmin rsa = (RemoteServiceAdmin)this.getRemoteServiceAdmin();
        if (rsa != null) {
            List<RemoteServiceAdmin.ExportRegistration> exportedRegistrations = rsa.getExportedRegistrations();
            for (RemoteServiceAdmin.ExportRegistration exportedRegistration : exportedRegistrations) {
                if (!exportedRegistration.match(serviceReference)) continue;
                this.trace("handleServiceModifying", "modifying exportRegistration for serviceReference=" + serviceReference);
                EndpointDescription updatedED = (EndpointDescription)exportedRegistration.update(null);
                if (updatedED != null) continue;
                this.logWarning("handleServiceModifying", "ExportRegistration.update failed with exception=" + exportedRegistration.getException());
            }
        }
    }

    protected void handleServiceUnregistering(ServiceReference serviceReference) {
        RemoteServiceAdmin rsa = (RemoteServiceAdmin)this.getRemoteServiceAdmin();
        if (rsa != null) {
            List<RemoteServiceAdmin.ExportRegistration> exportedRegistrations = ((RemoteServiceAdmin)this.getRemoteServiceAdmin()).getExportedRegistrations();
            for (RemoteServiceAdmin.ExportRegistration exportedRegistration : exportedRegistrations) {
                if (!exportedRegistration.match(serviceReference)) continue;
                this.trace("handleServiceUnregistering", "closing exportRegistration for serviceReference=" + serviceReference);
                exportedRegistration.close();
            }
        }
    }
}

