/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.common;

import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.engio.mbassy.common.IPredicate;

public class ReflectionUtils {
    public static List<Method> getMethods(IPredicate<Method> condition, Class<?> target) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Set supers = TypeToken.of(target).getTypes().rawTypes();
        try {
            for (Class superClazz : supers) {
                Method[] methodArray = superClazz.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (condition.apply(method)) {
                        methods.add(method);
                    }
                    ++n2;
                }
            }
        }
        catch (SecurityException e) {
            Throwables.propagate((Throwable)e);
        }
        return methods;
    }

    public static Method getOverridingMethod(Method overridingMethod, Class<?> subclass) {
        Class<?> current = subclass;
        while (!current.equals(overridingMethod.getDeclaringClass())) {
            try {
                Method overridden = current.getDeclaredMethod(overridingMethod.getName(), overridingMethod.getParameterTypes());
                return overridden;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                current = current.getSuperclass();
            }
        }
        return null;
    }

    public static List<Method> withoutOverridenSuperclassMethods(List<Method> allMethods) {
        LinkedList<Method> filtered = new LinkedList<Method>();
        for (Method method : allMethods) {
            if (ReflectionUtils.containsOverridingMethod(allMethods, method)) continue;
            filtered.add(method);
        }
        return filtered;
    }

    public static Collection<Class<?>> getSuperclasses(Class<?> from) {
        LinkedList superclasses = new LinkedList();
        while (!from.equals(Object.class)) {
            superclasses.add(from.getSuperclass());
            from = from.getSuperclass();
        }
        return superclasses;
    }

    public static boolean containsOverridingMethod(List<Method> allMethods, Method methodToCheck) {
        for (Method method : allMethods) {
            if (!ReflectionUtils.isOverriddenBy(methodToCheck, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverriddenBy(Method superclassMethod, Method subclassMethod) {
        if (superclassMethod.getDeclaringClass().equals(subclassMethod.getDeclaringClass()) || !superclassMethod.getDeclaringClass().isAssignableFrom(subclassMethod.getDeclaringClass()) || !superclassMethod.getName().equals(subclassMethod.getName())) {
            return false;
        }
        Class<?>[] superClassMethodParameters = superclassMethod.getParameterTypes();
        Class<?>[] subClassMethodParameters = superclassMethod.getParameterTypes();
        if (subClassMethodParameters.length != subClassMethodParameters.length) {
            return false;
        }
        int i = 0;
        while (i < subClassMethodParameters.length) {
            if (!superClassMethodParameters[i].equals(subClassMethodParameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

