/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.dispatch;

import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.common.ConcurrentSet;
import net.engio.mbassy.dispatch.DelegatingMessageDispatcher;
import net.engio.mbassy.dispatch.IMessageDispatcher;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.IMessageFilter;

public class FilteredMessageDispatcher
extends DelegatingMessageDispatcher {
    private final IMessageFilter[] filter;

    public FilteredMessageDispatcher(IMessageDispatcher dispatcher) {
        super(dispatcher);
        this.filter = dispatcher.getContext().getHandlerMetadata().getFilter();
    }

    private boolean passesFilter(Object message) {
        if (this.filter == null) {
            return true;
        }
        int i = 0;
        while (i < this.filter.length) {
            if (!this.filter[i].accepts(message, this.getContext().getHandlerMetadata())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void dispatch(MessagePublication publication, Object message, ConcurrentSet<?> listeners) {
        if (this.passesFilter(message)) {
            this.getDelegate().dispatch(publication, message, listeners);
        }
    }
}

