/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.modelbusexplorer.blackboard;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.engio.mbassy.bus.BusConfiguration;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.bus.SyncAsyncPostCommand;
import net.engio.mbassy.common.DeadMessage;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class ModelBusEventBusImpl
implements ModelBusEventBus {
    private static final Logger LOG = LoggerFactory.getLogger((String)ModelBusEventBus.class.getSimpleName());
    private final MBassador<Object> mbassador;
    private final Set<Object> listeners = Sets.newHashSet();

    public ModelBusEventBusImpl() {
        this.mbassador = new MBassador(BusConfiguration.Default());
        this.register(new DeadMessageListener());
    }

    @Override
    public void register(Object listener) {
        if (!this.listeners.contains(listener)) {
            if (listener instanceof Collection) {
                LOG.warn(String.format("Listener %s is of type %s is a collection. Please doublechek if this is what you want to register", listener.toString(), listener.getClass().getName()));
            }
            this.listeners.add(listener);
            this.mbassador.subscribe(listener);
        }
    }

    @Override
    public void unregister(Object listener) {
        this.listeners.remove(listener);
        this.mbassador.unsubscribe(listener);
    }

    @Override
    public void unregister(Collection<Object> listener) {
        for (Object l : listener) {
            this.unregister(l);
        }
    }

    @Override
    public void post(Object event) {
        ((SyncAsyncPostCommand)this.mbassador.post(event)).now();
    }

    @Override
    public void postAsync(Object event) {
        ((SyncAsyncPostCommand)this.mbassador.post(event)).asynchronously();
    }

    @Override
    public void unregisterAllListener() {
        for (Object listener : this.listeners) {
            this.mbassador.unsubscribe(listener);
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        this.mbassador.stop();
    }

    private class DeadMessageListener {
        private DeadMessageListener() {
        }

        @Handler
        public void deadMessageRecieved(DeadMessage message) {
            String msg = String.format("Dead message found! No reciever for %s found", message.getMessage().getClass().getName());
            LOG.warn(msg);
        }
    }
}

