/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiEventAdminNotifier;
import org.apache.camel.osgi.OsgiSpringCamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.BundleContextAware;

@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends org.apache.camel.spring.CamelContextFactoryBean
implements BundleContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBean.class);
    @XmlTransient
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        LOG.debug("Using BundleContext: {}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    @Override
    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = this.newCamelContext();
        if (!this.isImplicitId()) {
            ctx.setName(this.getId());
        }
        return ctx;
    }

    @Override
    protected SpringCamelContext newCamelContext() {
        return new OsgiSpringCamelContext(this.getApplicationContext(), this.getBundleContext());
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        ((SpringCamelContext)this.getContext()).getManagementStrategy().addEventNotifier(new OsgiCamelContextPublisher(this.bundleContext));
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            ((SpringCamelContext)this.getContext()).getManagementStrategy().addEventNotifier(new OsgiEventAdminNotifier(this.bundleContext));
        }
        catch (Throwable t) {
            LOG.debug("EventAdmin package is not available, just don't use it");
        }
    }
}

