/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.server.embedded;

import config.LocationProperty;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.server.embedded.HTTPServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static ServiceTracker tracker;
    static Logger logger;

    static {
        logger = LoggerFactory.getLogger(Activator.class);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        String repoLocation = null;
        PropertyConfigurator.configure((URL)bundleContext.getBundle().getEntry("resources/log4j.properties"));
        Hashtable<String, Object> options = new Hashtable<String, Object>();
        try {
            repoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation();
            logger.debug("No SSL encryption used. Repository location: " + repoLocation);
            URI repoURI = URI.createURI((String)repoLocation);
            ((Dictionary)options).put("context.path", "");
            ((Dictionary)options).put("http.enabled", Boolean.TRUE);
            ((Dictionary)options).put("http.host", repoURI.host());
            ((Dictionary)options).put("http.port", Integer.valueOf(repoURI.port()));
        }
        catch (Exception exception) {}
        String repoSecureLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getSecureRepositoryLocation();
        if (this.isLocationEmpty(repoLocation) && this.isLocationEmpty(repoSecureLocation)) {
            throw new RuntimeException("No ModelBus server location specified");
        }
        try {
            if (repoSecureLocation != null) {
                LocationProperty[] locProperties;
                logger.debug("Using SSL encryption. Repository location: " + repoSecureLocation);
                URI secureRepoURI = URI.createURI((String)repoSecureLocation);
                ((Dictionary)options).put("https.enabled", Boolean.TRUE);
                ((Dictionary)options).put("https.host", secureRepoURI.host());
                ((Dictionary)options).put("https.port", Integer.valueOf(secureRepoURI.port()));
                LocationProperty[] locationPropertyArray = locProperties = ModelBusConfiguration.getLocationProperties((String)"secureRepositoryLocation");
                int n = locProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    LocationProperty locProperty = locationPropertyArray[n2];
                    String propertyName = locProperty.getName();
                    String propertyValue = locProperty.getValue();
                    if ("SSLTrustStore".equals(propertyName)) {
                        System.setProperty("javax.net.ssl.trustStore", ModelBusConfiguration.getAbsoluteConfigFilePath((String)propertyValue));
                    } else if ("SSLKeyStore".equals(propertyName)) {
                        ((Dictionary)options).put("ssl.keystore", ModelBusConfiguration.getAbsoluteConfigFilePath((String)propertyValue));
                    } else if ("SSLTrustStorePassword".equals(propertyName)) {
                        System.setProperty("javax.net.ssl.trustStorePassword", propertyValue);
                    } else {
                        ((Dictionary)options).put(this.getJettyPropertyName(propertyName), propertyValue);
                    }
                    ++n2;
                }
                ((Dictionary)options).put("ssl.wantclientauth", Boolean.TRUE);
            } else {
                ((Dictionary)options).put("https.enabled", Boolean.FALSE);
            }
        }
        catch (ModelBusException exc) {
            ((Dictionary)options).put("https.enabled", Boolean.FALSE);
            logger.error("Error while configuring SSL", (Throwable)exc);
        }
        logger.debug("Starting web server...");
        JettyConfigurator.startServer((String)"ModelBusHTTPServer", options);
        tracker = new HTTPServiceTracker(bundleContext);
        tracker.open();
    }

    private boolean isLocationEmpty(String location) {
        return location == null || "".equals(location);
    }

    private String getJettyPropertyName(String modelBusPropertyName) {
        if ("SSLAlgorithm".equals(modelBusPropertyName)) {
            return "ssl.algorithm";
        }
        if ("SSLKeyStorePassword".equals(modelBusPropertyName)) {
            return "ssl.keypassword";
        }
        if ("SSLKeyStoreType".equals(modelBusPropertyName)) {
            return "ssl.keystoretype";
        }
        if ("SSLPassword".equals(modelBusPropertyName)) {
            return "ssl.password";
        }
        return modelBusPropertyName;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        tracker.close();
        tracker = null;
    }
}

