/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.diff;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;
import org.modelbus.tools.diffmerge.ui.diff.MatchingDiffModel;
import org.modelbus.tools.diffmerge.ui.diff.SelectNextDiffElementEvent;
import org.modelbus.tools.diffmerge2.joint.event.DiffModelChangedEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;

class DiffModelViewEventHandler {
    private final TreeViewer treeViewer;
    private DiffModel model;

    DiffModelViewEventHandler(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    @Handler
    public void diffModelChangedEventHandler(DiffModelChangedEvent event) {
        this.treeViewer.setAutoExpandLevel(3);
        this.model = event.getDiffModel().match() ? new MatchingDiffModel(event.getDiffModel()) : event.getDiffModel();
        this.treeViewer.setInput((Object)this.model);
        List subElements = this.model.getSubElements();
        if (!subElements.isEmpty()) {
            TreeItem item = this.treeViewer.getTree().getItem(0);
            this.treeViewer.getTree().select(item);
        }
    }

    @Handler
    public void selectNextDiffElementEventHandler(SelectNextDiffElementEvent event) {
        int idx;
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        DiffModelElement element = (DiffModelElement)selection.getFirstElement();
        if (element == null) {
            this.setFirstModelElementAsSelected();
            return;
        }
        if (element instanceof DiffElement) {
            idx = this.getPositionInDiffModel(element);
        } else {
            DiffElement first = (DiffElement)element.getAllDiffElements().getFirst();
            int tmp = this.getPositionInDiffModel((DiffModelElement)first);
            idx = event.isNext() ? tmp - 1 : tmp;
        }
        DiffCollection diffElements = this.model.getAllDiffElements();
        DiffElement next = event.isNext() ? (idx < diffElements.size() - 1 ? (DiffElement)diffElements.get(++idx) : (DiffElement)diffElements.get(0)) : (idx > 0 ? (DiffElement)diffElements.get(--idx) : (DiffElement)diffElements.get(diffElements.size() - 1));
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)next));
    }

    private void setFirstModelElementAsSelected() {
        if (this.model != null && !this.model.match()) {
            DiffElement first = (DiffElement)this.model.getAllDiffElements().getFirst();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)first));
        }
    }

    private int getPositionInDiffModel(DiffModelElement element) {
        DiffCollection diffElements = this.model.getAllDiffElements();
        int idx = diffElements.indexOf((Object)element);
        return idx;
    }
}

