/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.equinox.internal.util.string.CharBuffer;
import org.eclipse.equinox.internal.util.xml.Tag;

public class TagImpl
implements Tag {
    private CharBuffer fContent = null;
    private String fContentString = null;
    private String fName = null;
    private Hashtable fAttributes = null;
    private Vector fTags = null;
    private int fLine = -1;
    protected boolean fInline = false;
    private static Enumeration fEmptyEnumeration = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("Hashtable Enumerator");
        }
    };

    public String getAttribute(String aAttrName) {
        return this.fAttributes != null ? this.fAttributes.get(aAttrName) : null;
    }

    public Enumeration getAttributeNames() {
        return this.fAttributes != null ? this.fAttributes.keys() : fEmptyEnumeration;
    }

    public Enumeration getAttributeValues() {
        return this.fAttributes != null ? this.fAttributes.elements() : fEmptyEnumeration;
    }

    public String getName() {
        return this.fName;
    }

    public String getContent() {
        if (this.fContentString != null) {
            return this.fContentString;
        }
        if (this.fContent != null) {
            this.fContentString = this.fContent.trim();
            this.fContent = null;
            return this.fContentString;
        }
        return "";
    }

    public int getLine() {
        return this.fLine;
    }

    public int size() {
        return this.fTags != null ? this.fTags.size() : 0;
    }

    public Tag getTagAt(int aPosition) {
        return (Tag)this.fTags.elementAt(aPosition);
    }

    protected void setName(String aName) {
        this.fName = aName;
    }

    protected void addAttribute(String aAttrName, String aAttrValue) {
        if (this.fAttributes == null) {
            this.fAttributes = new Hashtable(1);
        }
        this.fAttributes.put(aAttrName, aAttrValue);
    }

    protected void addTag(Tag aTag) {
        if (this.fTags == null) {
            this.fTags = new Vector(2, 3);
        }
        this.fTags.addElement(aTag);
    }

    protected void appendContent(CharBuffer toAppend) {
        if (this.fContent == null) {
            this.fContent = new CharBuffer(toAppend.length());
        }
        this.fContent.append(toAppend.getValue());
    }

    protected void appendContent(String toAppend) {
        if (this.fContent == null) {
            this.fContent = new CharBuffer(toAppend.length());
        }
        this.fContent.append(toAppend);
    }

    protected CharBuffer getContentBuffer() {
        if (this.fContent == null) {
            this.fContent = new CharBuffer(5);
        }
        return this.fContent;
    }

    protected void setLine(int aLine) {
        this.fLine = aLine;
    }

    public String getContent(int aPos, String aName) {
        Tag child = this.getTagAt(aPos);
        if (child == null) {
            throw new NullPointerException("There is no such a tag. [Parent tag name] = [" + aName + "], [child tag index] = " + aPos + ", [child tag name] = [" + aName + ']');
        }
        if (child.getName().equals(aName)) {
            return child.getContent();
        }
        throw new IllegalArgumentException("There is no such a tag. [Parent tag name] = [" + aName + "], [child tag index] = " + aPos + ", [child tag name] = [" + aName + ']');
    }

    public void readObject(InputStream is) throws Exception {
        if (!(is instanceof ObjectInput)) {
            is = new ObjectInputStream(is);
        }
        this.readExternal((ObjectInput)((Object)is));
    }

    public void writeObject(OutputStream os) throws Exception {
        if (!(os instanceof ObjectOutput)) {
            os = new ObjectOutputStream(os);
        }
        this.writeExternal((ObjectOutput)((Object)os));
        os.flush();
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        int i;
        int size;
        this.fName = input.readUTF();
        boolean hasContent = input.readBoolean();
        if (hasContent) {
            this.fContentString = input.readUTF();
        }
        if ((size = input.readInt()) > 0) {
            this.fAttributes = new Hashtable(size, 1.0f);
            i = 0;
            while (i < size) {
                String key = input.readUTF();
                String val = input.readUTF();
                this.fAttributes.put(key, val);
                ++i;
            }
        }
        if ((size = input.readInt()) > 0) {
            this.fTags = new Vector(size);
            i = 0;
            while (i < size) {
                TagImpl tag = new TagImpl();
                tag.readExternal(input);
                this.fTags.addElement(tag);
                ++i;
            }
        }
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(this.fName);
        String content = null;
        if (this.fContentString != null) {
            content = this.fContentString;
        } else if (this.fContent != null) {
            content = this.fContent.trim();
        }
        if (content != null) {
            output.writeBoolean(true);
            output.writeUTF(content);
        } else {
            output.writeBoolean(false);
        }
        if (this.fAttributes != null) {
            output.writeInt(this.fAttributes.size());
            Enumeration e = this.fAttributes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)this.fAttributes.get(key);
                output.writeUTF(key);
                output.writeUTF(val);
            }
        } else {
            output.writeInt(0);
        }
        if (this.fTags != null) {
            output.writeInt(this.fTags.size());
            int i = 0;
            int size = this.fTags.size();
            while (i < size) {
                TagImpl current = (TagImpl)this.fTags.elementAt(i);
                current.writeExternal(output);
                ++i;
            }
        } else {
            output.writeInt(0);
        }
        output.flush();
    }

    public void writeXml(Writer out, int level) throws IOException {
        boolean isShort;
        boolean indent = level >= 0;
        int i = 0;
        while (indent && i < level) {
            out.write(32);
            ++i;
        }
        out.write(60);
        out.write(this.fName);
        if (this.fAttributes != null) {
            Enumeration e = this.fAttributes.keys();
            while (e.hasMoreElements()) {
                out.write(32);
                String key = (String)e.nextElement();
                String val = (String)this.fAttributes.get(key);
                out.write(key);
                out.write("=\"");
                out.write(val);
                out.write(34);
            }
        }
        String content = null;
        if (this.fContentString != null) {
            content = this.fContentString;
        } else if (this.fContent != null) {
            content = this.fContent.trim();
        }
        boolean bl = isShort = content == null && this.fTags == null;
        if (isShort) {
            out.write("/>");
            if (indent) {
                out.write(10);
            }
        } else {
            out.write(62);
            if (indent) {
                out.write(10);
            }
            int i2 = 0;
            while (this.fTags != null && i2 < this.fTags.size()) {
                TagImpl child = (TagImpl)this.fTags.elementAt(i2);
                child.writeXml(out, level < 0 ? -1 : level + 1);
                ++i2;
            }
            if (content != null) {
                i2 = 0;
                while (indent && i2 < level + 1) {
                    out.write(32);
                    ++i2;
                }
                out.write(content);
                if (indent) {
                    out.write(10);
                }
            }
            i2 = 0;
            while (indent && i2 < level) {
                out.write(32);
                ++i2;
            }
            out.write("</");
            out.write(this.fName);
            out.write(62);
            if (indent) {
                out.write(10);
            }
        }
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            this.writeXml(out, 0);
        }
        catch (IOException iOException) {}
        return ((Object)out).toString();
    }
}

