/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jaxws;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.URIID;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.provider.jaxws.JaxWsNamespace;
import org.eclipse.ecf.provider.jaxws.client.JaxWsClientService;
import org.eclipse.ecf.provider.jaxws.server.JaxWsRemoteService;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.RemoteServiceID;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteCallableRequestType;
import org.eclipse.ecf.remoteservice.client.RemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.provider.RemoteServiceContainerInstantiator;
import org.eclipse.ecf.remoteservice.provider.RemoteServiceDistributionProvider;
import org.osgi.framework.InvalidSyntaxException;

public class JaxWsContainer
extends AbstractClientContainer {
    protected final JaxWsParams params;

    public JaxWsContainer(ID containerID, JaxWsParams params) {
        super(containerID);
        this.params = params;
    }

    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        return false;
    }

    public Namespace getConnectNamespace() {
        return JaxWsNamespace.getInstance();
    }

    protected IRemoteService createRemoteService(RemoteServiceClientRegistration registration) {
        return new JaxWsClientService(this, registration, this.params);
    }

    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceID) {
        IRemoteServiceReference result = super.getRemoteServiceReference(serviceID);
        if (result == null) {
            String clazz = serviceID.getClass().getName();
            ID id = serviceID.getContainerID();
            result = this.registerCallableAndGetServiceReference(id, clazz)[0];
        }
        return result;
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        IRemoteServiceReference[] result = super.getRemoteServiceReferences(idFilter, clazz, filter);
        if (result == null) {
            result = this.registerCallableAndGetServiceReference(this.containerID, clazz);
        }
        return result;
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        IRemoteServiceReference[] result = super.getRemoteServiceReferences(target, clazz, filter);
        if (result == null) {
            result = this.registerCallableAndGetServiceReference(target, clazz);
        }
        return result;
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        IRemoteServiceReference[] result = super.getRemoteServiceReferences(target, idFilter, clazz, filter);
        if (result == null) {
            result = this.registerCallableAndGetServiceReference(target, clazz);
        }
        return result;
    }

    private IRemoteServiceReference[] registerCallableAndGetServiceReference(ID target, String clazz) {
        IRemoteCallable rc = this.createRemoteCallable((URIID)target, clazz);
        IRemoteServiceReference reference = this.registerCallables(new IRemoteCallable[]{rc}, null).getReference();
        return new IRemoteServiceReference[]{reference};
    }

    private IRemoteCallable createRemoteCallable(URIID target, String clazz) {
        String method = clazz;
        String resourcePath = target.toURI().getPath();
        IRemoteCallParameter[] defaultParameters = new IRemoteCallParameter[]{};
        IRemoteCallableRequestType requestType = null;
        return new RemoteCallable(method, resourcePath, defaultParameters, requestType);
    }

    protected String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        String address = this.params.getAddress();
        return address != null ? address : ((URIID)this.containerID).toURI().toString();
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        RemoteServiceID serviceID = new RemoteServiceID(this.containerID.getNamespace(), this.containerID, this.registry.getNextServiceId());
        return new JaxWsRemoteService(clazzes, service, this.params, properties, this.containerID, (IRemoteServiceID)serviceID);
    }

    public void connect(ID targetID, IConnectContext connectContext1) throws ContainerConnectException {
        super.connect(targetID, connectContext1);
    }

    public static class Instantiator
    extends RemoteServiceContainerInstantiator {
        private static final String PROPERTY_PREFIX = "org.eclipse.ecf.jaxws.";

        public Instantiator() {
            super(Arrays.asList("org.eclipse.ecf.jaxws"), (Map)new HashMap<String, List<String>>(){
                private static final long serialVersionUID = 2171939366541136696L;
                {
                    this.put("org.eclipse.ecf.jaxws", Arrays.asList("org.eclipse.ecf.jaxws"));
                }
            });
        }

        public IContainer createInstance(ContainerTypeDescription description, Map<String, ?> parameters) throws ContainerCreateException {
            URIID id = this.getIDParameterValue(parameters, "id", "http://localhost:8080/ws/service");
            int defaultTimeout = Instantiator.defaultTimeoutAsInt();
            JaxWsParams params = new JaxWsParams().setAddress(this.getParameterValue(parameters, "address")).setWsdlLocation(this.getParameterValue(parameters, "wsdl.location")).setWsdlServiceName(this.getParameterValue(parameters, "wsdl.service.name")).setWsdlServiceNs(this.getParameterValue(parameters, "wsdl.service.ns")).setWsdlPortName(this.getParameterValue(parameters, "wsdl.port.name")).setBindingId(this.getParameterValue(parameters, "binding")).setMtomEnabled(((Boolean)this.getParameterValue(parameters, "mtom.enabled", Boolean.class, true)).booleanValue()).setRequestTimeout(((Integer)this.getParameterValue(parameters, "request.timeout", Integer.class, defaultTimeout)).intValue()).setConnectTimeout(((Integer)this.getParameterValue(parameters, "connect.timeout", Integer.class, defaultTimeout)).intValue());
            return new JaxWsContainer((ID)id, params);
        }

        public static int defaultTimeoutAsInt() {
            long defaultTimeout = IRemoteCall.DEFAULT_TIMEOUT;
            return defaultTimeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)defaultTimeout;
        }

        protected <T> URIID getIDParameterValue(Map<String, ?> parameters, String key, String def) {
            JaxWsNamespace namespace = JaxWsNamespace.getInstance();
            return namespace.createInstance(new Object[]{this.getParameterValue(parameters, key, String.class, def)});
        }

        public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
            return Instantiator.copyDictionaryRemovingPrefix(exportedProperties, PROPERTY_PREFIX);
        }

        public static Dictionary<?, ?> copyDictionaryRemovingPrefix(Dictionary<?, ?> source, String prefix) {
            int prefixSkipIndex = prefix.length();
            Hashtable result = new Hashtable(source.size());
            Enumeration<?> keys = source.keys();
            while (keys.hasMoreElements()) {
                String keyStr;
                Object key = keys.nextElement();
                Object value = source.get(key);
                if (key instanceof String && (keyStr = (String)key).startsWith(prefix)) {
                    ((Dictionary)result).put(keyStr.substring(prefixSkipIndex), value);
                    continue;
                }
                ((Dictionary)result).put((String)key, value);
            }
            return result;
        }
    }

    public static class JaxWsDistributionProvider
    extends RemoteServiceDistributionProvider {
        public JaxWsDistributionProvider() {
            this.setName("org.eclipse.ecf.jaxws");
            this.setInstantiator((IContainerInstantiator)new Instantiator());
            this.setNamespace(JaxWsNamespace.getInstance());
            this.setServer(true);
            this.validateComplete();
        }
    }
}

