/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementLeaf;
import org.modelbus.tools.diffmerge.model.DiffKind;
import org.modelbus.tools.diffmerge.model.DiffSource;

class AttributeLeaf
extends DiffElementLeaf {
    private final DiffElement parent;

    AttributeLeaf(DiffElement parent) {
        super(parent);
        this.parent = parent;
    }

    public String toString() {
        String representation;
        EObject target;
        EObject source;
        EAttribute attribute = (EAttribute)this.parent.getAffectedFeature();
        String name = this.getNameFromNameFeature(attribute);
        DiffKind kind = this.parent.getKind();
        DiffSource src = this.parent.getSource();
        if (src == DiffSource.Right) {
            source = this.parent.getLeftElement();
            target = this.parent.getRightElement();
        } else {
            source = this.parent.getRightElement();
            target = this.parent.getLeftElement();
        }
        Object sourceValue = source.eGet((EStructuralFeature)attribute);
        Object targetValue = target.eGet((EStructuralFeature)attribute);
        switch (kind) {
            case Change: {
                representation = String.format("Atrribute '%s' changed from \"%s\" to \"%s\"", name, sourceValue.toString(), targetValue.toString());
                break;
            }
            default: {
                representation = "No representation implemented";
            }
        }
        return representation;
    }

    private String getNameFromNameFeature(EAttribute attribute) {
        String tmp;
        String name = "<no name>";
        EStructuralFeature nameFeat = attribute.eClass().getEStructuralFeature("name");
        if (nameFeat != null && (tmp = (String)attribute.eGet(nameFeat)) != null && !"".equals(tmp)) {
            name = tmp;
        }
        return name;
    }
}

