/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiCamelContextNameStrategy;
import org.apache.camel.core.osgi.OsgiClassResolver;
import org.apache.camel.core.osgi.OsgiComponentResolver;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiLanguageResolver;
import org.apache.camel.core.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.core.osgi.OsgiServiceRegistry;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiCamelContextHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(OsgiCamelContextHelper.class);

    private OsgiCamelContextHelper() {
    }

    public static void osgiUpdate(DefaultCamelContext camelContext, BundleContext bundleContext) {
        ObjectHelper.notNull(bundleContext, "BundleContext");
        LOG.debug("Using OsgiCamelContextNameStrategy");
        camelContext.setNameStrategy(new OsgiCamelContextNameStrategy(bundleContext));
        LOG.debug("Using OsgiClassResolver");
        camelContext.setClassResolver(new OsgiClassResolver(bundleContext));
        LOG.debug("Using OsgiFactoryFinderResolver");
        camelContext.setFactoryFinderResolver(new OsgiFactoryFinderResolver(bundleContext));
        LOG.debug("Using OsgiPackageScanClassResolver");
        camelContext.setPackageScanClassResolver(new OsgiPackageScanClassResolver(bundleContext));
        LOG.debug("Using OsgiComponentResolver");
        camelContext.setComponentResolver(new OsgiComponentResolver(bundleContext));
        LOG.debug("Using OsgiLanguageResolver");
        camelContext.setLanguageResolver(new OsgiLanguageResolver(bundleContext));
        LOG.debug("Using OsgiDataFormatResolver");
        camelContext.setDataFormatResolver(new OsgiDataFormatResolver(bundleContext));
    }

    public static Registry wrapRegistry(CamelContext camelContext, Registry registry, BundleContext bundleContext) {
        ObjectHelper.notNull(bundleContext, "BundleContext");
        LOG.debug("Setting up OSGi ServiceRegistry");
        OsgiServiceRegistry osgiServiceRegistry = new OsgiServiceRegistry(bundleContext);
        camelContext.addLifecycleStrategy(osgiServiceRegistry);
        CompositeRegistry compositeRegistry = new CompositeRegistry();
        compositeRegistry.addRegistry(osgiServiceRegistry);
        compositeRegistry.addRegistry(registry);
        return compositeRegistry;
    }
}

