/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.rap.rwt.theme.ControlThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledCompositeLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class ScrolledComposite
extends Composite {
    private final ControlAdapter contentListener;
    Control content;
    int minHeight = 0;
    int minWidth = 0;
    boolean expandHorizontal;
    boolean expandVertical;
    boolean alwaysShowScroll;
    boolean showFocusedControl;

    public ScrolledComposite(Composite parent, int style) {
        super(parent, ScrolledComposite.checkStyle(style));
        super.setLayout(new ScrolledCompositeLayout());
        this.contentListener = new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent event) {
                ScrolledComposite.this.layout();
            }
        };
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setOrigin(Point origin) {
        this.setOrigin(origin.x, origin.y);
    }

    public void setOrigin(int left, int top) {
        this.checkWidget();
        if (this.content != null && left >= 0 && top >= 0) {
            int x = left;
            int y = top;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setSelection(x);
                x = -hBar.getSelection();
            } else {
                x = 0;
            }
            ScrollBar vBar = this.getVerticalBar();
            if (vBar != null) {
                vBar.setSelection(y);
                y = -vBar.getSelection();
            } else {
                y = 0;
            }
            this.content.setLocation(x, y);
        }
    }

    public Point getOrigin() {
        Point result;
        this.checkWidget();
        if (this.content == null) {
            result = new Point(0, 0);
        } else {
            Point location = this.content.getLocation();
            result = new Point(-location.x, -location.y);
        }
        return result;
    }

    public void setAlwaysShowScrollBars(boolean show) {
        this.checkWidget();
        if (!show != !this.alwaysShowScroll) {
            ScrollBar vBar;
            this.alwaysShowScroll = show;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null && this.alwaysShowScroll) {
                hBar.setVisible(true);
            }
            if ((vBar = this.getVerticalBar()) != null && this.alwaysShowScroll) {
                vBar.setVisible(true);
            }
            this.layout();
        }
    }

    public boolean getAlwaysShowScrollBars() {
        return this.alwaysShowScroll;
    }

    public boolean getExpandHorizontal() {
        this.checkWidget();
        return this.expandHorizontal;
    }

    public boolean getExpandVertical() {
        this.checkWidget();
        return this.expandVertical;
    }

    public void setExpandHorizontal(boolean expand) {
        this.checkWidget();
        if (expand != this.expandHorizontal) {
            this.expandHorizontal = expand;
            this.layout();
        }
    }

    public void setExpandVertical(boolean expand) {
        this.checkWidget();
        if (expand != this.expandVertical) {
            this.expandVertical = expand;
            this.layout();
        }
    }

    public void setMinWidth(int width) {
        this.setMinSize(width, this.minHeight);
    }

    public int getMinWidth() {
        this.checkWidget();
        return this.minWidth;
    }

    public void setMinHeight(int height) {
        this.setMinSize(this.minWidth, height);
    }

    public int getMinHeight() {
        this.checkWidget();
        return this.minHeight;
    }

    public void setMinSize(Point size) {
        if (size == null) {
            this.setMinSize(0, 0);
        } else {
            this.setMinSize(size.x, size.y);
        }
    }

    public void setMinSize(int width, int height) {
        this.checkWidget();
        if (width != this.minWidth || height != this.minHeight) {
            this.minWidth = Math.max(0, width);
            this.minHeight = Math.max(0, height);
            this.layout();
        }
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.removeControlListener(this.contentListener);
            this.content.setBounds(new Rectangle(-200, -200, 0, 0));
        }
        this.content = content;
        ScrollBar vBar = this.getVerticalBar();
        ScrollBar hBar = this.getHorizontalBar();
        if (this.content != null) {
            if (vBar != null) {
                vBar.setMaximum(0);
                vBar.setThumb(0);
                vBar.setSelection(0);
            }
            if (hBar != null) {
                hBar.setMaximum(0);
                hBar.setThumb(0);
                hBar.setSelection(0);
            }
            content.setLocation(0, 0);
            this.layout();
            this.content.addControlListener(this.contentListener);
        } else {
            if (hBar != null) {
                hBar.setVisible(this.alwaysShowScroll);
            }
            if (vBar != null) {
                vBar.setVisible(this.alwaysShowScroll);
            }
        }
    }

    public Control getContent() {
        return this.content;
    }

    public void setShowFocusedControl(boolean show) {
        this.checkWidget();
        if (this.showFocusedControl != show) {
            Control control;
            this.showFocusedControl = show;
            if (this.showFocusedControl && this.contains(control = this.getDisplay().getFocusControl())) {
                this.showControl(control);
            }
        }
    }

    public boolean getShowFocusedControl() {
        this.checkWidget();
        return this.showFocusedControl;
    }

    public void showControl(Control control) {
        this.checkWidget();
        if (control == null) {
            SWT.error(4);
        }
        if (control.isDisposed()) {
            SWT.error(5);
        }
        if (!this.contains(control)) {
            SWT.error(5);
        }
        Rectangle itemRect = this.getDisplay().map((Control)control.getParent(), (Control)this, control.getBounds());
        Rectangle area = this.getClientArea();
        Point origin = this.getOrigin();
        if (itemRect.x < 0) {
            origin.x = Math.max(0, origin.x + itemRect.x);
        } else if (area.width < itemRect.x + itemRect.width) {
            int minWidth = Math.min(itemRect.width, area.width);
            origin.x = Math.max(0, origin.x + itemRect.x + minWidth - area.width);
        }
        if (itemRect.y < 0) {
            origin.y = Math.max(0, origin.y + itemRect.y);
        } else if (area.height < itemRect.y + itemRect.height) {
            int minHeight = Math.min(itemRect.height, area.height);
            origin.y = Math.max(0, origin.y + itemRect.y + minHeight - area.height);
        }
        this.setOrigin(origin);
    }

    boolean contains(Control control) {
        boolean result = false;
        if (control != null && !control.isDisposed()) {
            Composite parent = control.getParent();
            while (parent != null && !(parent instanceof Shell) && !result) {
                if (this == parent) {
                    result = true;
                }
                parent = parent.getParent();
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            ScrollBar verticalBar;
            ScrollBar horizontalBar;
            if (this.content != null && !this.content.isDisposed()) {
                this.content.removeControlListener(this.contentListener);
            }
            if ((horizontalBar = this.getHorizontalBar()) != null) {
                horizontalBar.dispose();
            }
            if ((verticalBar = this.getVerticalBar()) != null) {
                verticalBar.dispose();
            }
            super.dispose();
        }
    }

    boolean needHScroll(Rectangle contentRect, boolean vVisible) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return false;
        }
        Rectangle hostRect = this.getBounds();
        BoxDimensions border = this.getAdapter(ControlThemeAdapter.class).getBorder(this);
        hostRect.width -= border.left + border.right;
        ScrollBar vBar = this.getVerticalBar();
        if (vVisible && vBar != null) {
            hostRect.width -= vBar.getSize().x;
        }
        if (!this.expandHorizontal && contentRect.width > hostRect.width) {
            return true;
        }
        return this.expandHorizontal && this.minWidth > hostRect.width;
    }

    boolean needVScroll(Rectangle contentRect, boolean hVisible) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return false;
        }
        Rectangle hostRect = this.getBounds();
        BoxDimensions border = this.getAdapter(ControlThemeAdapter.class).getBorder(this);
        hostRect.height -= border.top + border.bottom;
        ScrollBar hBar = this.getHorizontalBar();
        if (hVisible && hBar != null) {
            hostRect.height -= hBar.getSize().y;
        }
        if (!this.expandVertical && contentRect.height > hostRect.height) {
            return true;
        }
        return this.expandVertical && this.minHeight > hostRect.height;
    }

    private static int checkStyle(int style) {
        int mask = 0x2000B00;
        return style & mask;
    }
}

