/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge;

import com.google.common.collect.Sets;
import java.util.Set;
import org.modelbus.tools.diffmerge.DiffMergeImpl;
import org.modelbus.tools.diffmerge.IDiffMerge;
import org.modelbus.tools.diffmerge.compare.Comparer;
import org.modelbus.tools.diffmerge.match.MatchInspector;
import org.modelbus.tools.diffmerge.match.Matcher;
import org.modelbus.tools.diffmerge.model.identifier.DefaultIdentifier;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.modelbusexplorer.blackboard.EventBusProvider;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class DiffMergeBuilder {
    private final Set<MatchInspector> inspectors = Sets.newHashSet();
    private ModelBusEventBus eventBus;
    private ModelIdentifier identifier;

    public static DiffMergeBuilder builder() {
        return new DiffMergeBuilder();
    }

    private DiffMergeBuilder() {
    }

    public DiffMergeBuilder setModelBusEventBus(ModelBusEventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    public DiffMergeBuilder setModelIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public DiffMergeBuilder setMatchInspector(MatchInspector inspector) {
        this.inspectors.add(inspector);
        return this;
    }

    public DiffMergeBuilder removeMatchInspector(MatchInspector inspector) {
        this.inspectors.remove(inspector);
        return this;
    }

    public IDiffMerge createNewDiffMerge(Matcher matcher) {
        if (this.eventBus == null) {
            this.setModelBusEventBus(EventBusProvider.getRunningEventBusInstance());
        }
        return this.createNewDiffMerge(matcher, this.eventBus);
    }

    public IDiffMerge createNewDiffMerge(Matcher matcher, ModelBusEventBus eventBus) {
        if (this.identifier == null) {
            this.identifier = new DefaultIdentifier();
        }
        Comparer comparer = this.createComparer(matcher);
        DiffMergeImpl diffMergeImpl = new DiffMergeImpl(eventBus, comparer);
        for (Object handler : diffMergeImpl.getAllEventHandlers()) {
            eventBus.register(handler);
        }
        return diffMergeImpl;
    }

    private Comparer createComparer(Matcher matcher) {
        Comparer comparer = new Comparer(matcher, this.identifier, this.inspectors);
        for (Object handler : comparer.getAllEventHandlers()) {
            this.eventBus.register(handler);
        }
        return comparer;
    }

    public void destroyDiffMerge(IDiffMerge diffmerge) {
        ModelBusEventBus bus = diffmerge.getEventBus();
        for (Object handler : diffmerge.getAllEventHandlers()) {
            bus.unregister(handler);
        }
    }
}

