/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.git;

import java.net.MalformedURLException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.git.GitUtil;
import org.modelbus.services.repository.server.impl.ModelBusDirEntryImpl;

public class ModelBusGitDirEntry
extends ModelBusDirEntryImpl {
    public ModelBusGitDirEntry(String filePath, Repository repository, RevCommit commit) throws MalformedURLException {
        ObjectLoader loader;
        this.repositoryLocation = repository.getDirectory().getParentFile().getPath();
        try {
            loader = GitUtil.getObjectLoader(repository, filePath, commit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        URI fileURI = URI.createURI((String)filePath);
        this.name = fileURI.lastSegment();
        this.kind = ModelBusGitDirEntry.convertGitNodeKindToModelBusNodeKind(loader.getType());
        this.size = loader.getSize();
        this.revision = GitUtil.getCommitRevision(commit);
        this.creationDate = GitUtil.getCommitDate(commit);
        this.lastAuthor = GitUtil.getCommitAuthor(commit);
        this.commitMessage = GitUtil.getCommitMessage(commit);
        this.url = "http:/";
        if (!"/".equals(filePath)) {
            this.url = String.valueOf(this.url) + "/" + filePath;
        }
    }

    public static ModelBusNodeKind convertGitNodeKindToModelBusNodeKind(int gitKind) {
        if (gitKind == 2) {
            return ModelBusNodeKind.DIR;
        }
        if (gitKind == 3) {
            return ModelBusNodeKind.FILE;
        }
        return ModelBusNodeKind.UNKNOWN;
    }
}

