/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.status;

import org.eclipse.swt.widgets.Display;
import org.modelbus.core.lib.IServicesHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.types.Status;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.status.ModelBusStatusProvider;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;

public class ModelBusRepositoryPing
extends Thread {
    private final long interval;
    private boolean stop = false;
    private IServicesHelper servicesHelper = null;
    private final ModelBusStatusProvider statusProvider;
    private final UserSessionHelper userSessionHelper;
    private final Display display;

    public ModelBusRepositoryPing(long interval, Display display, ModelBusStatusProvider statusProvider, UserSessionHelper userSessionHelper) {
        this.statusProvider = statusProvider;
        this.userSessionHelper = userSessionHelper;
        this.display = display;
        if (interval < 0L) {
            throw new IllegalArgumentException("Value for ping interval has to be non negative.");
        }
        this.interval = interval;
    }

    @Override
    public void run() {
        while (!this.stop) {
            if (this.userSessionHelper.getSession() != null) {
                try {
                    if (this.servicesHelper == null) {
                        this.servicesHelper = ModelBusCoreLib.getServicesHelper();
                    }
                    Status status = this.servicesHelper.getStatus(this.userSessionHelper.getSession(), true);
                    this.statusProvider.setStatus(status);
                }
                catch (RepositoryAuthentificationException e) {
                    this.statusProvider.registerException((Exception)((Object)e));
                    this.statusProvider.setAvailable(false);
                }
                catch (Exception exception) {
                    this.statusProvider.setAvailable(false);
                }
            } else {
                this.statusProvider.setAvailable(false);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public void kill() {
        this.stop = true;
    }
}

