/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.filter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelbus.tools.diffmerge.filter.DiffMergeFilter;
import org.modelbus.tools.diffmerge.filter.DiffMergeFilterUpdateEvent;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.diffmerge2.joint.config.AbstractConfig;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class DiffMergeFilterImpl
extends AbstractConfig
implements DiffMergeFilter,
EventBusParticipant {
    private boolean ignoreOrder;
    private EAttribute[] attributes;
    private EReference[] references;
    private Set<EStructuralFeature> whiteList = Sets.newHashSet();
    private Set<String> featureNames = Sets.newHashSet();
    private ModelBusEventBus eventBus;
    private boolean filterAllButSingleElements;

    public DiffMergeFilterImpl() {
    }

    public DiffMergeFilterImpl(ModelBusEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public DiffMergeFilter ignoreOrderingChanges(boolean value) {
        this.ignoreOrder = value;
        return this;
    }

    @Override
    public DiffMergeFilter ignoreAttriubtes(EAttribute ... attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public DiffMergeFilter ignoreAllAttributes(boolean value) {
        this.filterAllButSingleElements = false;
        return this;
    }

    @Override
    public DiffMergeFilter ignoreAllReferences(boolean value) {
        this.filterAllButSingleElements = false;
        return this;
    }

    @Override
    public DiffMergeFilter ignoreReferences(EReference ... references) {
        this.filterAllButSingleElements = false;
        this.references = references;
        return this;
    }

    @Override
    public DiffMergeFilter ignorAllBut(EStructuralFeature ... features) {
        this.whiteList.addAll(Arrays.asList(features));
        return this;
    }

    public void update() {
        Preconditions.checkNotNull((Object)this.eventBus);
        if (this.attributes == null) {
            this.attributes = new EAttribute[0];
        }
        if (this.references == null) {
            this.references = new EReference[0];
        }
        EStructuralFeature[] whites = this.whiteList.toArray(new EStructuralFeature[this.whiteList.size()]);
        String[] names = this.featureNames.toArray(new String[this.featureNames.size()]);
        this.eventBus.post((Object)new DiffMergeFilterUpdateEvent(this.attributes, this.references, names, whites, this.ignoreOrder, !this.filterAllButSingleElements));
    }

    public Collection<Object> getAllEventHandlers() {
        return Lists.newArrayList((Object[])new Object[]{this});
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public DiffMergeFilter ignoreAllByName(String ... featureNames) {
        this.featureNames.addAll(Arrays.asList(featureNames));
        return this;
    }

    @Override
    public DiffMergeFilter ignoreAllButNames(String ... featureNames) {
        this.filterAllButSingleElements = true;
        this.featureNames.addAll(Arrays.asList(featureNames));
        return this;
    }

    @Override
    public DiffMergeFilter clear() {
        this.featureNames.clear();
        this.ignoreOrder = false;
        this.attributes = null;
        this.references = null;
        this.whiteList.clear();
        this.featureNames.clear();
        return this;
    }
}

