/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.adapterfactory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankedAdapterFactoryDescriptorRegistryImpl
implements RankedAdapterFactoryDescriptor.Registry {
    private final ComposedAdapterFactory.Descriptor.Registry delegateRegistry;
    private final Multimap<Collection<?>, RankedAdapterFactoryDescriptor> emfCompareAdapterFactoryRegistry;

    public RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry delegateRegistry, Multimap<Collection<?>, RankedAdapterFactoryDescriptor> adapterFactoryRegistryBackingMultimap) {
        this.delegateRegistry = delegateRegistry;
        this.emfCompareAdapterFactoryRegistry = adapterFactoryRegistryBackingMultimap;
    }

    public ComposedAdapterFactory.Descriptor getDescriptor(Collection<?> types) {
        RankedAdapterFactoryDescriptor ret = this.getRankedDescriptor(types);
        if (ret == null) {
            ret = this.delegatedGetDescriptor(types);
        }
        return ret;
    }

    private RankedAdapterFactoryDescriptor getRankedDescriptor(Collection<?> types) {
        ArrayList<String> stringTypes = new ArrayList<String>(types.size());
        for (Object key : types) {
            if (key instanceof EPackage) {
                stringTypes.add(((EPackage)key).getNsURI());
                continue;
            }
            if (key instanceof Package) {
                stringTypes.add(((Package)key).getName());
                continue;
            }
            if (!(key instanceof Class)) continue;
            stringTypes.add(((Class)key).getName());
        }
        return this.getHighestRankedDescriptor(stringTypes);
    }

    private RankedAdapterFactoryDescriptor getHighestRankedDescriptor(List<String> stringTypes) {
        RankedAdapterFactoryDescriptor result;
        Iterator descriptors = this.emfCompareAdapterFactoryRegistry.get(stringTypes).iterator();
        if (descriptors.hasNext()) {
            RankedAdapterFactoryDescriptor highestRanking = (RankedAdapterFactoryDescriptor)descriptors.next();
            while (descriptors.hasNext()) {
                RankedAdapterFactoryDescriptor descriptor = (RankedAdapterFactoryDescriptor)descriptors.next();
                if (descriptor.getRanking() <= highestRanking.getRanking()) continue;
                highestRanking = descriptor;
            }
            result = highestRanking;
        } else {
            result = null;
        }
        return result;
    }

    protected ComposedAdapterFactory.Descriptor delegatedGetDescriptor(Collection<?> types) {
        if (this.delegateRegistry != null) {
            return this.delegateRegistry.getDescriptor(types);
        }
        return null;
    }

    @Override
    public Set<RankedAdapterFactoryDescriptor> getDescriptors() {
        return ImmutableSet.copyOf((Collection)this.emfCompareAdapterFactoryRegistry.values());
    }
}

