/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class BeanExpression
implements Expression,
Predicate {
    private Object bean;
    private String beanName;
    private Class<?> type;
    private String method;

    public BeanExpression(Object bean, String method) {
        this.bean = bean;
        this.method = method;
    }

    public BeanExpression(String beanName, String method) {
        this.beanName = beanName;
        this.method = method;
    }

    public BeanExpression(Class<?> type, String method) {
        this.type = type;
        this.method = method;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeanExpression[");
        if (this.bean != null) {
            sb.append(this.bean.toString());
        } else if (this.beanName != null) {
            sb.append(this.beanName);
        } else if (this.type != null) {
            sb.append(ObjectHelper.className(this.type));
        }
        if (this.method != null) {
            sb.append(" method: ").append(this.method);
        }
        sb.append("]");
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        BeanHolder holder;
        if (this.bean != null) {
            holder = new ConstantBeanHolder(this.bean, exchange.getContext());
        } else if (this.beanName != null) {
            holder = new RegistryBean(exchange.getContext(), this.beanName);
        } else if (this.type != null) {
            holder = new ConstantTypeBeanHolder(this.type, exchange.getContext());
        } else {
            throw new IllegalArgumentException("Either bean, beanName or type should be set on " + this);
        }
        if (OgnlHelper.isInvalidValidOgnlExpression(this.method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(this.method);
            throw new RuntimeBeanExpressionException(exchange, this.beanName, this.method, cause);
        }
        if (OgnlHelper.isValidOgnlExpression(this.method)) {
            OgnlInvokeProcessor ognl = new OgnlInvokeProcessor(holder, this.method);
            try {
                ognl.process(exchange);
                return ognl.getResult();
            }
            catch (Exception e) {
                throw new RuntimeBeanExpressionException(exchange, this.beanName, this.method, e);
            }
        }
        InvokeProcessor invoke = new InvokeProcessor(holder, this.method);
        try {
            invoke.process(exchange);
            return invoke.getResult();
        }
        catch (Exception e) {
            throw new RuntimeBeanExpressionException(exchange, this.beanName, this.method, e);
        }
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        return exchange.getContext().getTypeConverter().convertTo(type, result);
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    private final class OgnlInvokeProcessor
    implements Processor {
        private final String ognl;
        private final BeanHolder beanHolder;
        private Object result;

        public OgnlInvokeProcessor(BeanHolder beanHolder, String ognl) {
            this.beanHolder = beanHolder;
            this.ognl = ognl;
            this.result = beanHolder.getBean();
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            Exchange resultExchange = exchange.copy();
            resultExchange.setException(null);
            resultExchange.setPattern(ExchangePattern.InOut);
            resultExchange.getIn().removeHeader("CamelBeanMethodName");
            String ognlPath = "";
            Object beanToCall = this.beanHolder.getBean();
            if (beanToCall == null) {
                throw new IllegalArgumentException("Bean instance is null. OGNL bean expressions requires bean instances.");
            }
            List<String> methods = OgnlHelper.splitOgnl(this.ognl);
            for (String methodName : methods) {
                ConstantBeanHolder holder = new ConstantBeanHolder(beanToCall, exchange.getContext());
                boolean nullSafe = OgnlHelper.isNullSafeOperator(methodName);
                ognlPath = ognlPath + methodName;
                methodName = OgnlHelper.removeLeadingOperators(methodName);
                String key = null;
                KeyValueHolder<String, String> index = OgnlHelper.isOgnlIndex(methodName);
                if (index != null) {
                    methodName = index.getKey();
                    key = index.getValue();
                }
                if (methodName != null) {
                    InvokeProcessor invoke = new InvokeProcessor(holder, methodName);
                    invoke.process(resultExchange);
                    if (resultExchange.getException() != null) {
                        throw new RuntimeBeanExpressionException(exchange, BeanExpression.this.beanName, methodName, resultExchange.getException());
                    }
                    this.result = invoke.getResult();
                }
                if (key != null) {
                    this.result = this.lookupResult(resultExchange, key, this.result, nullSafe, ognlPath, holder.getBean());
                }
                if (this.result == null && nullSafe) {
                    return;
                }
                beanToCall = this.result;
            }
        }

        private Object lookupResult(Exchange exchange, String key, Object result, boolean nullSafe, String ognlPath, Object bean) {
            List list;
            boolean checkList;
            ObjectHelper.notEmpty(key, "key", "in Simple language ognl path: " + ognlPath);
            key = key.trim();
            key = StringHelper.removeLeadingAndEndingQuotes(key);
            Map map = exchange.getContext().getTypeConverter().convertTo(Map.class, result);
            if (map != null) {
                return map.get(key);
            }
            Integer num = exchange.getContext().getTypeConverter().convertTo(Integer.class, key);
            boolean bl = checkList = key.startsWith("last") || num != null;
            if (checkList && (list = exchange.getContext().getTypeConverter().convertTo(List.class, result)) != null) {
                if (key.startsWith("last")) {
                    num = list.size() - 1;
                    String after = ObjectHelper.after(key, "-");
                    if (after != null) {
                        Integer redux = exchange.getContext().getTypeConverter().convertTo(Integer.class, after.trim());
                        if (redux != null) {
                            num = num - redux;
                        } else {
                            throw new ExpressionIllegalSyntaxException(key);
                        }
                    }
                }
                if (num != null && num >= 0 && list.size() > num - 1) {
                    return list.get(num);
                }
                if (!nullSafe) {
                    throw new IndexOutOfBoundsException("Index: " + num + ", Size: " + list.size() + " out of bounds with List from bean: " + bean + "using OGNL path [" + ognlPath + "]");
                }
            }
            if (!nullSafe) {
                throw new IndexOutOfBoundsException("Key: " + key + " not found in bean: " + bean + " of type: " + ObjectHelper.classCanonicalName(bean) + " using OGNL path [" + ognlPath + "]");
            }
            return null;
        }

        public Object getResult() {
            return this.result;
        }
    }

    private final class InvokeProcessor
    implements Processor {
        private BeanHolder beanHolder;
        private String methodName;
        private Object result;

        private InvokeProcessor(BeanHolder beanHolder, String methodName) {
            this.beanHolder = beanHolder;
            this.methodName = methodName;
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            BeanProcessor processor = new BeanProcessor(this.beanHolder);
            if (this.methodName != null) {
                processor.setMethod(this.methodName);
                processor.setShorthandMethod(true);
            }
            try {
                Exchange resultExchange = exchange.copy();
                resultExchange.setException(null);
                resultExchange.setPattern(ExchangePattern.InOut);
                processor.process(resultExchange);
                this.result = resultExchange.getOut().getBody();
                if (resultExchange.getException() != null) {
                    exchange.setException(resultExchange.getException());
                }
            }
            catch (Exception e) {
                throw new RuntimeBeanExpressionException(exchange, BeanExpression.this.beanName, this.methodName, e);
            }
        }

        public Object getResult() {
            return this.result;
        }
    }
}

