/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.RouteNode;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDebugger
implements Debugger,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDebugger.class);
    private final List<BreakpointConditions> breakpoints = new CopyOnWriteArrayList<BreakpointConditions>();
    private final int maxConcurrentSingleSteps = 1;
    private final Map<String, Breakpoint> singleSteps = new HashMap<String, Breakpoint>(1);
    private CamelContext camelContext;

    public DefaultDebugger() {
    }

    public DefaultDebugger(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void addBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.add(new BreakpointConditions(breakpoint));
    }

    @Override
    public void addBreakpoint(Breakpoint breakpoint, Condition ... conditions) {
        if (conditions != null && conditions.length > 0) {
            this.breakpoints.add(new BreakpointConditions(breakpoint, Arrays.asList(conditions)));
        } else {
            this.breakpoints.add(new BreakpointConditions(breakpoint));
        }
    }

    @Override
    public void addSingleStepBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.add(new BreakpointConditions(breakpoint));
    }

    @Override
    public void addSingleStepBreakpoint(final Breakpoint breakpoint, Condition ... conditions) {
        Breakpoint singlestep = new Breakpoint(){

            @Override
            public Breakpoint.State getState() {
                return breakpoint.getState();
            }

            @Override
            public void suspend() {
                breakpoint.suspend();
            }

            @Override
            public void activate() {
                breakpoint.activate();
            }

            @Override
            public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition definition) {
                breakpoint.beforeProcess(exchange, processor, definition);
            }

            @Override
            public void afterProcess(Exchange exchange, Processor processor, ProcessorDefinition definition, long timeTaken) {
                breakpoint.afterProcess(exchange, processor, definition, timeTaken);
            }

            @Override
            public void onEvent(Exchange exchange, EventObject event, ProcessorDefinition definition) {
                if (event instanceof ExchangeCreatedEvent) {
                    exchange.getContext().getDebugger().startSingleStepExchange(exchange.getExchangeId(), this);
                } else if (event instanceof ExchangeCompletedEvent) {
                    exchange.getContext().getDebugger().stopSingleStepExchange(exchange.getExchangeId());
                }
                breakpoint.onEvent(exchange, event, definition);
            }

            public String toString() {
                return breakpoint.toString();
            }
        };
        this.addBreakpoint(singlestep, conditions);
    }

    @Override
    public void removeBreakpoint(Breakpoint breakpoint) {
        for (BreakpointConditions condition : this.breakpoints) {
            if (!condition.getBreakpoint().equals(breakpoint)) continue;
            this.breakpoints.remove(condition);
        }
    }

    @Override
    public void suspendAllBreakpoints() {
        for (BreakpointConditions breakpoint : this.breakpoints) {
            breakpoint.getBreakpoint().suspend();
        }
    }

    @Override
    public void activateAllBreakpoints() {
        for (BreakpointConditions breakpoint : this.breakpoints) {
            breakpoint.getBreakpoint().activate();
        }
    }

    @Override
    public List<Breakpoint> getBreakpoints() {
        ArrayList<Breakpoint> answer = new ArrayList<Breakpoint>(this.breakpoints.size());
        for (BreakpointConditions e : this.breakpoints) {
            answer.add(e.getBreakpoint());
        }
        return Collections.unmodifiableList(answer);
    }

    @Override
    public boolean startSingleStepExchange(String exchangeId, Breakpoint breakpoint) {
        if (this.singleSteps.size() >= 1) {
            return false;
        }
        this.singleSteps.put(exchangeId, breakpoint);
        return true;
    }

    @Override
    public void stopSingleStepExchange(String exchangeId) {
        this.singleSteps.remove(exchangeId);
    }

    @Override
    public boolean beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition definition) {
        Breakpoint singleStep = this.singleSteps.get(exchange.getExchangeId());
        if (singleStep != null) {
            this.onBeforeProcess(exchange, processor, definition, singleStep);
            return true;
        }
        boolean match = false;
        for (BreakpointConditions breakpoint : this.breakpoints) {
            if (!Breakpoint.State.Active.equals((Object)breakpoint.getBreakpoint().getState()) || !this.matchConditions(exchange, processor, definition, breakpoint)) continue;
            match = true;
            this.onBeforeProcess(exchange, processor, definition, breakpoint.getBreakpoint());
        }
        return match;
    }

    @Override
    public boolean afterProcess(Exchange exchange, Processor processor, ProcessorDefinition definition, long timeTaken) {
        Breakpoint singleStep = this.singleSteps.get(exchange.getExchangeId());
        if (singleStep != null) {
            this.onAfterProcess(exchange, processor, definition, timeTaken, singleStep);
            return true;
        }
        boolean match = false;
        for (BreakpointConditions breakpoint : this.breakpoints) {
            if (!Breakpoint.State.Active.equals((Object)breakpoint.getBreakpoint().getState()) || !this.matchConditions(exchange, processor, definition, breakpoint)) continue;
            match = true;
            this.onAfterProcess(exchange, processor, definition, timeTaken, breakpoint.getBreakpoint());
        }
        return match;
    }

    @Override
    public boolean onEvent(Exchange exchange, EventObject event) {
        Breakpoint singleStep = this.singleSteps.get(exchange.getExchangeId());
        if (singleStep != null) {
            this.onEvent(exchange, event, singleStep);
            return true;
        }
        boolean match = false;
        for (BreakpointConditions breakpoint : this.breakpoints) {
            if (!Breakpoint.State.Active.equals((Object)breakpoint.getBreakpoint().getState()) || !this.matchConditions(exchange, event, breakpoint)) continue;
            match = true;
            this.onEvent(exchange, event, breakpoint.getBreakpoint());
        }
        return match;
    }

    protected void onBeforeProcess(Exchange exchange, Processor processor, ProcessorDefinition definition, Breakpoint breakpoint) {
        try {
            breakpoint.beforeProcess(exchange, processor, definition);
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred in breakpoint: " + breakpoint + ". This exception will be ignored.", e);
        }
    }

    protected void onAfterProcess(Exchange exchange, Processor processor, ProcessorDefinition definition, long timeTaken, Breakpoint breakpoint) {
        try {
            breakpoint.afterProcess(exchange, processor, definition, timeTaken);
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred in breakpoint: " + breakpoint + ". This exception will be ignored.", e);
        }
    }

    protected void onEvent(Exchange exchange, EventObject event, Breakpoint breakpoint) {
        RouteNode node;
        ProcessorDefinition<?> definition = null;
        if (exchange.getUnitOfWork() != null && exchange.getUnitOfWork().getTracedRouteNodes() != null && (node = exchange.getUnitOfWork().getTracedRouteNodes().getLastNode()) != null) {
            definition = node.getProcessorDefinition();
        }
        try {
            breakpoint.onEvent(exchange, event, definition);
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred in breakpoint: " + breakpoint + ". This exception will be ignored.", e);
        }
    }

    private boolean matchConditions(Exchange exchange, Processor processor, ProcessorDefinition definition, BreakpointConditions breakpoint) {
        if (breakpoint.getConditions() != null && !breakpoint.getConditions().isEmpty()) {
            for (Condition condition : breakpoint.getConditions()) {
                if (condition.matchProcess(exchange, processor, definition)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matchConditions(Exchange exchange, EventObject event, BreakpointConditions breakpoint) {
        if (breakpoint.getConditions() != null && !breakpoint.getConditions().isEmpty()) {
            for (Condition condition : breakpoint.getConditions()) {
                if (condition.matchEvent(exchange, event)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext", this);
        this.camelContext.getManagementStrategy().addEventNotifier(new DebugEventNotifier());
        Tracer tracer = Tracer.getTracer(this.camelContext);
        if (tracer == null) {
            tracer = Tracer.createTracer(this.camelContext);
            tracer.setLogLevel(LoggingLevel.OFF);
            this.camelContext.addService(tracer);
            this.camelContext.addInterceptStrategy(tracer);
        }
        tracer.setEnabled(true);
    }

    @Override
    public void stop() throws Exception {
        this.breakpoints.clear();
        this.singleSteps.clear();
    }

    public String toString() {
        return "DefaultDebugger";
    }

    private final class DebugEventNotifier
    extends EventNotifierSupport {
        private DebugEventNotifier() {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreServiceEvents(true);
        }

        @Override
        public void notify(EventObject event) throws Exception {
            AbstractExchangeEvent aee = (AbstractExchangeEvent)event;
            Exchange exchange = aee.getExchange();
            DefaultDebugger.this.onEvent(exchange, event);
            if (event instanceof ExchangeCompletedEvent) {
                DefaultDebugger.this.singleSteps.remove(exchange.getExchangeId());
            }
        }

        @Override
        public boolean isEnabled(EventObject event) {
            return event instanceof AbstractExchangeEvent;
        }

        @Override
        protected void doStart() throws Exception {
        }

        @Override
        protected void doStop() throws Exception {
        }
    }

    private final class BreakpointConditions {
        private Breakpoint breakpoint;
        private List<Condition> conditions;

        private BreakpointConditions(Breakpoint breakpoint) {
            this(breakpoint, (List<Condition>)null);
        }

        private BreakpointConditions(Breakpoint breakpoint, List<Condition> conditions) {
            this.breakpoint = breakpoint;
            this.conditions = conditions;
        }

        public Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }
    }
}

