/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.util;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.util.ImageUtil;

public class GuiHelperUtil {
    private final ImageUtil imageeUtil;

    public GuiHelperUtil(Display display, UIConfig config) {
        this.imageeUtil = new ImageUtil(display, config);
    }

    public static void setStructViewTreeItemOverlay(TreeItem item, Image baseImage, Image overlay) {
        ImageDescriptor overDesc = ImageDescriptor.createFromImage((Image)overlay);
        DecorationOverlayIcon icon = new DecorationOverlayIcon(baseImage, overDesc, 1);
        Image result = icon.createImage();
        item.setImage(result);
    }

    public Image getDiffModelElementImage(Object element) {
        return null;
    }

    public Image setOverlay(Image baseImage, Image overlayImage) {
        if (baseImage == null && overlayImage == null) {
            return null;
        }
        if (baseImage == null) {
            return overlayImage;
        }
        if (overlayImage != null) {
            ImageDescriptor overDesc = ImageDescriptor.createFromImage((Image)overlayImage);
            DecorationOverlayIcon icon = new DecorationOverlayIcon(baseImage, overDesc, 2);
            Image result = icon.createImage();
            return result;
        }
        return baseImage;
    }

    public Image setOccurrenceOverlay(Image baseImage) {
        Image result = this.setOverlay(baseImage, this.imageeUtil.getOccurenceOverlayImage());
        return result;
    }

    public Image getEcoreImage(EObject ecoreElement) {
        String className = ecoreElement.eClass().getName();
        return this.getEcoreImageForEClassName(className);
    }

    public Image getEcoreImageForEClassName(String className) {
        return this.imageeUtil.getEcoreImage(className);
    }

    public Image getModelElementImage(Notifier modelElement) {
        Image classImage = modelElement instanceof EObject ? this.imageeUtil.getModelImage((EObject)modelElement) : this.getUiImage("resource");
        return classImage;
    }

    public Image getDiffModelElementImage() {
        return this.imageeUtil.getDiffGroupImage();
    }

    public Image getDiffModelImage() {
        return this.imageeUtil.getDiffModelImage();
    }

    public Image getUiImage(String imageName) {
        return this.imageeUtil.getUIIcon(imageName);
    }

    public Image getOutgoingChangeOverlay() {
        return this.imageeUtil.getOutChangeImage();
    }

    public Image getIncommingChangeOverlay() {
        return this.imageeUtil.getIncomeChangeImage();
    }

    public Image getConflictOverlay() {
        return this.imageeUtil.getConflictImage();
    }
}

