/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import java.io.File;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.AbstractLocationsUtil;

public class DefaultLocationsUtil
extends AbstractLocationsUtil {
    @Override
    public String getNotificationLocation() {
        String notificationLocation;
        block2: {
            notificationLocation = null;
            try {
                notificationLocation = ModelBusConfiguration.getLocation("notificationLocation");
            }
            catch (Exception exception) {
                System.out.println("ModelBus configuration model could not be loaded to obtain value for notification location. Relying on environment variable MODELBUS_NOTIFICATION_LOCATION.");
                notificationLocation = System.getenv("MODELBUS_NOTIFICATION_LOCATION");
                if (notificationLocation != null && !"".equals(notificationLocation)) break block2;
                System.out.println("Environment variable MODELBUS_NOTIFICATION_LOCATION is not set.");
                throw new RuntimeException("No ModelBus notification location set.");
            }
        }
        return notificationLocation;
    }

    @Override
    public String getSecureRepositoryLocation() {
        String secureRepoLocation = null;
        try {
            secureRepoLocation = ModelBusConfiguration.getLocation("secureRepositoryLocation");
        }
        catch (Exception exception) {}
        return secureRepoLocation;
    }

    @Override
    public String getModelBusConfigModelFolderLocation() throws ModelBusException {
        return String.valueOf(ModelBusConfiguration.getModelBusRootLocation()) + File.separator + "serverConfiguration";
    }

    @Override
    public String getModelBusConfigModelLocation() throws ModelBusException {
        return String.valueOf(this.getModelBusConfigModelFolderLocation()) + File.separator + "modelbus.config";
    }

    @Override
    protected boolean isSSLConnectionForced() {
        return ModelBusCoreLib.getRepositoryHelper().forcesSecureConnection();
    }

    @Override
    protected boolean enableTryToUseSSL() {
        return true;
    }
}

