/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.compare;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.compare.ModelCompareEditorInput;
import org.modelbus.desktop.model.SelectRevisionDialog;
import org.modelbus.desktop.util.ModelBusDesktopUtil;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;

public class CompareRepositoryItemWithRevisionActionDelegate
implements IObjectActionDelegate {
    private RepositoryDirEntry item;
    private Shell shell;

    public void run(IAction action) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        SelectRevisionDialog dialog = new SelectRevisionDialog(this.shell, this.item, "Select a revision to compare the head revision with", false);
        int status = dialog.open();
        if (status == 0) {
            String selectedRevision = dialog.getSelectedRevision();
            RepositoryDirEntry otherEntry = ModelBusDesktopUtil.cloneRepositoryEntry(this.item);
            otherEntry.setRevision(selectedRevision);
            try {
                page.openEditor((IEditorInput)new ModelCompareEditorInput(this.item, otherEntry), "org.modelbus.desktop.CompareEditor");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Iterator selIt;
        this.item = null;
        if (UserSessionHelper.getInstance().getSession() == null) {
            action.setEnabled(false);
            return;
        }
        if (selection instanceof IStructuredSelection && (selIt = ((IStructuredSelection)selection).iterator()).hasNext()) {
            this.item = (RepositoryDirEntry)selIt.next();
        }
        action.setEnabled(this.item != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

