/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.project.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.dosgi.repository.descriptor.Session;

public class AbstractProjectSetup {
    protected void checkoutRepositoryItemToTempFolder(RepositoryDirEntry item, File dir) throws IOException {
        IRepositoryHelper repoHelper = ModelBusCoreLib.getRepositoryHelper();
        Session session = UserSessionHelper.getInstance().getSession();
        URI itemURI = URI.createURI((String)item.getUri());
        if (item.getKind() == RepositoryNodeKind.DIR) {
            RepositoryDirEntry[] subEntries;
            File tempDir = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + item.getName());
            if (!tempDir.exists() && !tempDir.mkdir()) {
                throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
            }
            try {
                subEntries = repoHelper.getDirEntries(session, itemURI, "-1");
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (subEntries != null) {
                RepositoryDirEntry[] repositoryDirEntryArray = subEntries;
                int n = subEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryDirEntry subEntry = repositoryDirEntryArray[n2];
                    this.checkoutRepositoryItemToTempFolder(subEntry, tempDir);
                    ++n2;
                }
            }
        } else {
            int len;
            InputStream iStream;
            try {
                iStream = repoHelper.checkOutFile(session, itemURI, "-1");
            }
            catch (Exception exception) {
                return;
            }
            File f = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + item.getName());
            FileOutputStream out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = iStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            out.flush();
            ((OutputStream)out).close();
            iStream.close();
        }
    }

    protected void copyDirContentToRepository(String parentFileName, File dir) throws Exception {
        File[] dirContent;
        if (!dir.isDirectory()) {
            return;
        }
        Session session = UserSessionHelper.getInstance().getSession();
        IRepositoryHelper repoHelper = ModelBusCoreLib.getRepositoryHelper();
        File[] fileArray = dirContent = dir.listFiles();
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.copyDirContentToRepository(String.valueOf(parentFileName) + "/" + file.getName(), file);
            } else {
                URI targetURI = URI.createURI((String)parentFileName).appendSegment(file.getName());
                repoHelper.checkInFile(session, targetURI, file, "Project structure commit");
            }
            ++n2;
        }
    }
}

