/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.types;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.types.IModelBusDataSource;

public class DefaultModelBusDataSource
implements IModelBusDataSource {
    protected DataSource dataSource;
    protected URI uri;
    protected File tempFile;

    public DefaultModelBusDataSource(URI uri, DataSource dataSource) {
        this.dataSource = dataSource;
        try {
            String lastSegment = uri.lastSegment();
            if (lastSegment == null) {
                lastSegment = "temp";
            }
            this.tempFile = File.createTempFile(lastSegment, ".modelbus");
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
            InputStream inputStream = dataSource.getInputStream();
            byte[] buffer = new byte[1024];
            int read = inputStream.read(buffer);
            while (read > 0) {
                fileOutputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            inputStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.uri = uri;
    }

    @Override
    public String getContentType() {
        return this.dataSource.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.tempFile));
    }

    @Override
    public String getName() {
        return this.dataSource.getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.dataSource.getOutputStream();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }
}

