/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui;

import com.google.common.collect.Sets;
import java.util.Set;
import org.modelbus.tools.diffmerge.ui.DiffMergeView;
import org.modelbus.tools.diffmerge.ui.UIListener;
import org.modelbus.tools.diffmerge.ui.UIListenerUpdateEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class UIEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)UIEventHandler.class.getName());
    private Set<UIListener> listeners = Sets.newHashSet();

    void addListener(UIListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(UIListener listener) {
        this.listeners.remove(listener);
    }

    @Handler
    public void updateUiListenerEventHandler(UIListenerUpdateEvent event) {
        LOG.debug(String.format("Recieved %s ", event.getClass().getSimpleName()));
        switch (event.getButtonType()) {
            case COMMIT: {
                this.notifyListenersForCommit(event.getSource());
                break;
            }
            case UPDATE: {
                this.notifyListenersForUpdate(event.getSource());
                break;
            }
            case CANCEL: {
                this.notifyListenersForCancel(event.getSource());
                break;
            }
            case OK: {
                this.notifyListenersForOk(event.getSource());
                break;
            }
        }
    }

    private void notifyListenersForCancel(DiffMergeView source) {
        for (UIListener uil : this.listeners) {
            uil.onCancelButtonClicked(source);
        }
    }

    private void notifyListenersForUpdate(DiffMergeView source) {
        for (UIListener uil : this.listeners) {
            uil.onUpdateButtonClicked(source);
        }
    }

    private void notifyListenersForCommit(DiffMergeView diffMergeView) {
        for (UIListener uil : this.listeners) {
            uil.onCommitButtonClicked(diffMergeView);
        }
    }

    private void notifyListenersForOk(DiffMergeView source) {
        for (UIListener uil : this.listeners) {
            uil.onOkButtonClicked(source);
        }
    }
}

