/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.config;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.modelbus.tools.diffmerge.ui.config.UIButtonConfig;
import org.modelbus.tools.diffmerge.ui.config.UIButtonConfigImpl;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.config.UIConfigUpdateEvent;
import org.modelbus.tools.diffmerge.ui.properties.PropertiesConfigEvent;
import org.modelbus.tools.diffmerge2.joint.config.AbstractConfig;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

public class UIConfigImpl
extends AbstractConfig
implements UIConfig {
    private String iconPath = "/org/modelbus/tools/diffmerge/gui/icons/UML";
    private UIButtonConfig buttonConfig = new UIButtonConfigImpl();
    private final UIConfigUpdateEvent event = new UIConfigUpdateEvent(this.getConfigID(), UIConfig.DiffMergeMode.SYNCHRONIZE, this.iconPath);
    private ModelBusEventBus eventBus;
    private boolean propertyEditingEnabled = true;

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public UIButtonConfig getButtonConfig() {
        return this.buttonConfig;
    }

    @Override
    public UIConfig setButtonConfig(UIButtonConfig uiConfig) {
        this.buttonConfig = uiConfig;
        return this;
    }

    @Override
    public UIConfig setCommitMode() {
        this.event.setMode(UIConfig.DiffMergeMode.COMMIT);
        return this;
    }

    @Override
    public UIConfig setUpdateMode() {
        this.event.setMode(UIConfig.DiffMergeMode.UPDATE);
        return this;
    }

    @Override
    public UIConfig setSynchronizeMode() {
        this.event.setMode(UIConfig.DiffMergeMode.SYNCHRONIZE);
        return this;
    }

    @Override
    public UIConfig setNoActionMode() {
        this.event.setMode(UIConfig.DiffMergeMode.NONE);
        return this;
    }

    public void update() {
        switch (this.event.getMode()) {
            case COMMIT: {
                this.getButtonConfig().hideUpdateButton().showCommitButton().update();
                break;
            }
            case UPDATE: {
                this.getButtonConfig().hideCommitButtion().showUpdateButton().update();
                break;
            }
            case SYNCHRONIZE: {
                this.getButtonConfig().showCommitButton().showUpdateButton().update();
                break;
            }
            default: {
                this.getButtonConfig().hideCommitButtion().hideUpdateButton().update();
            }
        }
        this.eventBus.post((Object)this.event);
        this.eventBus.post((Object)new PropertiesConfigEvent(this.propertyEditingEnabled));
    }

    @Override
    public UIConfig setModelIconsPath(String pathToModelIcons) {
        this.iconPath = pathToModelIcons;
        this.event.setIconPath(pathToModelIcons);
        return this;
    }

    public Collection<Object> getAllEventHandlers() {
        return Sets.newHashSet();
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public UIConfig setModelName(String name) {
        this.event.setModelName(name);
        return this;
    }

    @Override
    public UIConfig setEditingSupportEnabled(boolean value) {
        this.propertyEditingEnabled = value;
        return this;
    }
}

