/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.git;

import config.LocationProperty;
import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IRepositoryFactory;
import org.modelbus.services.repository.server.git.GitModelBusRepository;

public class ModelBusGitRepositoryFactory
implements IRepositoryFactory {
    public IModelBusRepository createModelBusRepository(boolean forceCreation) {
        String gitLocation;
        LocationProperty emailProperty;
        LocationProperty userNameProperty;
        String gitUserEmail;
        String gitUsername;
        URI repositoryLocation;
        block10: {
            repositoryLocation = null;
            gitUsername = null;
            gitUserEmail = null;
            userNameProperty = null;
            emailProperty = null;
            try {
                gitLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getGitLocation();
                if (gitLocation != null) break block10;
                return null;
            }
            catch (ModelBusException e) {
                e.printStackTrace();
                return null;
            }
        }
        repositoryLocation = URI.createURI((String)gitLocation);
        userNameProperty = ModelBusConfiguration.getLocationProperty((String)"gitRepositoryLocation", (String)"GitUserName");
        emailProperty = ModelBusConfiguration.getLocationProperty((String)"gitRepositoryLocation", (String)"GitUserEmail");
        if (userNameProperty == null) {
            System.err.println("Warning: Unable to connect to git repository: No git user provided in ModelBus configuration.");
            return null;
        }
        gitUsername = userNameProperty.getValue();
        if (emailProperty == null) {
            System.err.println("Warning: Unable to connect to git repository: No git user email provided in ModelBus configuration.");
            return null;
        }
        gitUserEmail = emailProperty.getValue();
        File repo = new File(repositoryLocation.toFileString());
        Repository repository = null;
        try {
            repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(String.valueOf(repo.getPath()) + "/.git"))).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!repo.exists() && forceCreation) {
            try {
                repository.create();
                StoredConfig config = repository.getConfig();
                config.setString("user", null, "name", gitUsername);
                config.setString("user", null, "email", gitUserEmail);
                config.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new GitModelBusRepository(repository);
    }
}

