/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.operations.MessageEndOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateOperations
extends MessageEndOperations {
    protected GateOperations() {
    }

    public static boolean validateActualGateMatched(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateInsideCfMatched(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOutsideCfMatched(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateFormalGateDistinguishable(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateActualGateDistinguishable(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOutsideCfGateDistinguishable(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateInsideCfGateDistinguishable(Gate gate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean isOutsideCF(Gate gate) {
        EList<MessageEnd> oppositeEnd = gate.oppositeEnd();
        EObject eContainer = gate.eContainer();
        if (oppositeEnd.size() > 0 && eContainer instanceof CombinedFragment) {
            EObject oppGateEContainer;
            InteractionOperand cfEnclosingOperand;
            MessageEnd oppEnd = (MessageEnd)oppositeEnd.get(0);
            CombinedFragment combinedFragment = (CombinedFragment)eContainer;
            UniqueEList.FastCompare cfFragments = new UniqueEList.FastCompare();
            Interaction cfEnclosingInteraction = combinedFragment.getEnclosingInteraction();
            if (cfEnclosingInteraction != null) {
                cfFragments.add((Object)cfEnclosingInteraction);
            }
            if ((cfEnclosingOperand = combinedFragment.getEnclosingOperand()) != null) {
                cfFragments.add((Object)cfEnclosingOperand);
            }
            UniqueEList.FastCompare oppFragments = new UniqueEList.FastCompare();
            if (oppEnd instanceof MessageOccurrenceSpecification) {
                InteractionOperand oppEnclosingOperand;
                MessageOccurrenceSpecification oppMOS = (MessageOccurrenceSpecification)oppEnd;
                Interaction oppEnclosingInteraction = oppMOS.getEnclosingInteraction();
                if (oppEnclosingInteraction != null) {
                    oppFragments.add((Object)oppEnclosingInteraction);
                }
                if ((oppEnclosingOperand = oppMOS.getEnclosingOperand()) != null) {
                    oppFragments.add((Object)oppEnclosingOperand);
                }
            } else if (oppEnd instanceof Gate && (oppGateEContainer = oppEnd.eContainer()) instanceof CombinedFragment) {
                InteractionOperand oppEnclosingOperand;
                CombinedFragment oppGateCF = (CombinedFragment)oppGateEContainer;
                Interaction oppEnclosingInteraction = oppGateCF.getEnclosingInteraction();
                if (oppEnclosingInteraction != null) {
                    oppFragments.add((Object)oppEnclosingInteraction);
                }
                if ((oppEnclosingOperand = oppGateCF.getEnclosingOperand()) != null) {
                    oppFragments.add((Object)oppEnclosingOperand);
                }
            }
            return cfFragments.equals((Object)oppFragments);
        }
        return false;
    }

    public static boolean isInsideCF(Gate gate) {
        EList<MessageEnd> oppositeEnd = gate.oppositeEnd();
        EObject eContainer = gate.eContainer();
        if (oppositeEnd.size() > 0 && eContainer instanceof CombinedFragment) {
            MessageEnd oppEnd = (MessageEnd)oppositeEnd.get(0);
            CombinedFragment combinedFragment = (CombinedFragment)eContainer;
            if (oppEnd instanceof MessageOccurrenceSpecification) {
                InteractionOperand oppEnclosingOperand = ((MessageOccurrenceSpecification)oppEnd).getEnclosingOperand();
                return combinedFragment == (oppEnclosingOperand == null ? null : oppEnclosingOperand.eContainer());
            }
            EObject oppGateEContainer = oppEnd.eContainer();
            if (oppGateEContainer instanceof CombinedFragment) {
                InteractionOperand oppEnclosingOperand = ((CombinedFragment)oppGateEContainer).getEnclosingOperand();
                return combinedFragment == (oppEnclosingOperand == null ? null : oppEnclosingOperand.eContainer());
            }
        }
        return false;
    }

    public static boolean isActual(Gate gate) {
        return gate.eContainingFeature() == UMLPackage.Literals.INTERACTION_USE__ACTUAL_GATE;
    }

    public static boolean isFormal(Gate gate) {
        return gate.eContainingFeature() == UMLPackage.Literals.INTERACTION__FORMAL_GATE;
    }

    public static String getName(Gate gate) {
        return gate.getName();
    }

    public static boolean matches(Gate gate, Gate gateToMatch) {
        if (GateOperations.safeEquals((Object)gate.getName(), (Object)gateToMatch.getName())) {
            Message message = gate.getMessage();
            Message messageToMatch = gateToMatch.getMessage();
            if (message == null) {
                return messageToMatch == null;
            }
            if (messageToMatch == null) {
                return false;
            }
            return !(!GateOperations.safeEquals((Object)((Object)message.getMessageSort()), (Object)((Object)messageToMatch.getMessageSort())) || !GateOperations.safeEquals((Object)message.getName(), (Object)messageToMatch.getName()) || message.getSendEvent() == gate && messageToMatch.getReceiveEvent() != gateToMatch || message.getReceiveEvent() == gate && messageToMatch.getSendEvent() != gateToMatch || !GateOperations.safeEquals((Object)message.getSignature(), (Object)messageToMatch.getSignature()));
        }
        return false;
    }

    public static InteractionOperand getOperand(Gate gate) {
        EList<MessageEnd> oppositeEnd;
        if (gate.isInsideCF() && (oppositeEnd = gate.oppositeEnd()).size() > 0) {
            EObject eContainer;
            MessageEnd oppEnd = (MessageEnd)oppositeEnd.get(0);
            if (oppEnd instanceof MessageOccurrenceSpecification) {
                return ((MessageOccurrenceSpecification)oppEnd).getEnclosingOperand();
            }
            if (oppEnd instanceof Gate && (eContainer = oppEnd.eContainer()) instanceof CombinedFragment) {
                return ((CombinedFragment)eContainer).getEnclosingOperand();
            }
        }
        return null;
    }

    public static boolean isDistinguishableFrom(Gate gate, NamedElement n, Namespace ns) {
        return true;
    }
}

