/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import config.LocationProperty;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.LocationsUtilFactory;

public abstract class AbstractLocationsUtil {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private final Map<String, String> cachedProxyData = new HashMap<String, String>();

    public String getSVNLocation() {
        String location;
        boolean isFile;
        String svnLocation;
        block9: {
            block8: {
                svnLocation = null;
                isFile = false;
                location = null;
                try {
                    location = ModelBusConfiguration.getLocation("svnRepositoryLocation");
                }
                catch (Exception exception) {
                    System.out.println("ModelBus configuration model could not be loaded to obtain value for SVN location. Relying on environment variable MODELBUS_SVN_REPOSITORY_LOCATION.");
                    svnLocation = System.getenv("MODELBUS_SVN_REPOSITORY_LOCATION");
                    if (svnLocation != null && !"".equals(svnLocation)) break block8;
                    System.out.println("Environment variable MODELBUS_SVN_REPOSITORY_LOCATION is not set.");
                    throw new RuntimeException("No ModelBus SVN repository location set.");
                }
            }
            if (location == null) {
                return null;
            }
            try {
                new URL(location);
            }
            catch (MalformedURLException malformedURLException) {
                URI uri = URI.createURI((String)location);
                isFile = !"svn".equals(uri.scheme());
            }
            catch (Exception exception) {
                System.out.println("ModelBus configuration model could not be loaded to obtain value for SVN location. Relying on environment variable MODELBUS_SVN_REPOSITORY_LOCATION.");
                svnLocation = System.getenv("MODELBUS_SVN_REPOSITORY_LOCATION");
                if (svnLocation != null && !"".equals(svnLocation)) break block9;
                System.out.println("Environment variable MODELBUS_SVN_REPOSITORY_LOCATION is not set.");
                throw new RuntimeException("No ModelBus SVN repository location set.");
            }
        }
        try {
            svnLocation = isFile ? "file://" + ModelBusConfiguration.getAbsoluteRootFilePath(location) : location;
        }
        catch (Exception exception) {
            throw new RuntimeException("No ModelBus SVN repository location set.");
        }
        return svnLocation;
    }

    public String getGitLocation() {
        String gitLocation = null;
        boolean isFile = false;
        String location = null;
        try {
            location = ModelBusConfiguration.getLocation("gitRepositoryLocation");
        }
        catch (Exception exception) {
            throw new RuntimeException("No ModelBus Git repository location set.");
        }
        if (location == null) {
            return null;
        }
        try {
            new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            URI uri = URI.createURI((String)location);
            isFile = !"git".equals(uri.scheme());
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid ModelBus Git repository location set.");
        }
        try {
            gitLocation = isFile ? "file://" + ModelBusConfiguration.getAbsoluteRootFilePath(location) : location;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid ModelBus Git repository location set.");
        }
        return gitLocation;
    }

    public String getNotificationLocation() {
        String notificationLocation;
        block2: {
            notificationLocation = null;
            try {
                notificationLocation = ModelBusConfiguration.getLocation("notificationLocation");
            }
            catch (Exception exception) {
                System.out.println("ModelBus configuration model could not be loaded to obtain value for notification location. Relying on environment variable MODELBUS_NOTIFICATION_LOCATION.");
                notificationLocation = System.getenv("MODELBUS_NOTIFICATION_LOCATION");
                if (notificationLocation != null && !"".equals(notificationLocation)) break block2;
                System.out.println("Environment variable MODELBUS_NOTIFICATION_LOCATION is not set.");
                throw new RuntimeException("No ModelBus notification location set.");
            }
        }
        return notificationLocation;
    }

    public static final String getExternalLocation(String uri) {
        if (uri.indexOf("0.0.0.0") == -1) {
            return uri;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String ipAddr = addr.getHostAddress();
            return uri.replace("0.0.0.0", ipAddr);
        }
        catch (UnknownHostException unknownHostException) {
            return uri;
        }
    }

    public static void setupSSLConnection() throws ModelBusException {
        LocationProperty trustStoreProperty = ModelBusConfiguration.getLocationProperty("secureRepositoryLocation", "SSLTrustStore");
        if (trustStoreProperty != null) {
            System.setProperty("javax.net.ssl.trustStore", ModelBusConfiguration.getAbsoluteConfigFilePath(trustStoreProperty.getValue()));
            LocationProperty trustStorePasswordProperty = ModelBusConfiguration.getLocationProperty("secureRepositoryLocation", "SSLTrustStorePassword");
            if (trustStorePasswordProperty == null) {
                throw new ModelBusException("Trust store password has to be provided.");
            }
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePasswordProperty.getValue());
        }
    }

    protected boolean isLocationEmpty(String location) {
        return location == null || "".equals(location);
    }

    public String getRepositoryLocation() {
        return this.getRepositoryLocation(false);
    }

    public String getRepositoryLocation(boolean tryToUseSSL) {
        String repoLocation = null;
        try {
            if (this.isSSLConnectionForced()) {
                repoLocation = this.getSecureRepositoryLocation();
                AbstractLocationsUtil.setupSSLConnection();
            } else {
                if (tryToUseSSL && this.enableTryToUseSSL() && (repoLocation = this.getSecureRepositoryLocation()) != null) {
                    AbstractLocationsUtil.setupSSLConnection();
                }
                if (repoLocation == null) {
                    repoLocation = ModelBusConfiguration.getLocation("repositoryLocation");
                }
            }
        }
        catch (ModelBusException modelBusException) {
            System.out.println("ModelBus configuration model could not be loaded to obtain value for repository location. Relying on environment variable MODELBUS_REPOSITORY_LOCATION.");
            repoLocation = System.getenv("MODELBUS_REPOSITORY_LOCATION");
            if (this.isLocationEmpty(repoLocation)) {
                System.out.println("Environment variable MODELBUS_REPOSITORY_LOCATION is not set.");
                throw new RuntimeException("No ModelBus repository location set.");
            }
            return repoLocation;
        }
        if (this.isLocationEmpty(repoLocation)) {
            throw new RuntimeException("No ModelBus repository location set.");
        }
        return repoLocation;
    }

    public URI getProxyURI(boolean tryToUseSSL) {
        return this.getProxyURI(tryToUseSSL, false);
    }

    public URI getConfiguredProxyURI(boolean tryToUseSSL) {
        return this.getProxyURI(tryToUseSSL, true);
    }

    private URI getProxyURI(boolean tryToUseSSL, boolean fromCache) {
        String proxyHost = null;
        String proxyPort = null;
        String protocol = "https";
        if (this.isSSLConnectionForced()) {
            proxyHost = this.getProxySetting(HTTPS_PROXY_HOST, fromCache);
            proxyPort = this.getProxySetting(HTTPS_PROXY_PORT, fromCache);
        } else {
            if (tryToUseSSL && this.enableTryToUseSSL()) {
                proxyHost = this.getProxySetting(HTTPS_PROXY_HOST, fromCache);
                proxyPort = this.getProxySetting(HTTPS_PROXY_PORT, fromCache);
            }
            if (proxyHost == null || proxyPort == null) {
                proxyHost = this.getProxySetting(HTTP_PROXY_HOST, fromCache);
                proxyPort = this.getProxySetting(HTTP_PROXY_PORT, fromCache);
                protocol = "http";
            }
        }
        if (proxyHost == null) {
            return null;
        }
        return URI.createURI((String)(String.valueOf(protocol) + "://" + proxyHost + ":" + proxyPort));
    }

    private String getProxySetting(String propName, boolean checkCache) {
        if (checkCache && this.cachedProxyData.containsKey(propName)) {
            return this.cachedProxyData.get(propName);
        }
        return System.getProperty(propName);
    }

    public void disableProxy() {
        URI hostURI = URI.createURI((String)LocationsUtilFactory.getInstance().getLocationsUtil().getHostAddress(true));
        URI proxyURI = this.getProxyURI(true);
        String hostPort = null;
        if (hostURI != null) {
            hostPort = hostURI.port();
        }
        String proxyPort = null;
        if (proxyURI != null) {
            proxyPort = proxyURI.port();
        }
        if (hostPort == null || proxyPort == null) {
            return;
        }
        if (!hostPort.equals(proxyPort)) {
            return;
        }
        this.cacheSystemProperty(HTTP_PROXY_HOST);
        this.cacheSystemProperty(HTTP_PROXY_PORT);
        this.cacheSystemProperty(HTTPS_PROXY_HOST);
        this.cacheSystemProperty(HTTPS_PROXY_PORT);
        System.getProperties().remove(HTTP_PROXY_HOST);
        System.getProperties().remove(HTTP_PROXY_PORT);
        System.getProperties().remove(HTTPS_PROXY_HOST);
        System.getProperties().remove(HTTPS_PROXY_PORT);
    }

    public void enableProxy() {
        this.restoreProxySetting(HTTP_PROXY_HOST);
        this.restoreProxySetting(HTTP_PROXY_PORT);
        this.restoreProxySetting(HTTPS_PROXY_HOST);
        this.restoreProxySetting(HTTPS_PROXY_PORT);
        this.cachedProxyData.remove(HTTP_PROXY_HOST);
        this.cachedProxyData.remove(HTTP_PROXY_PORT);
        this.cachedProxyData.remove(HTTPS_PROXY_HOST);
        this.cachedProxyData.remove(HTTPS_PROXY_PORT);
    }

    private void cacheSystemProperty(String propName) {
        String property = System.getProperty(propName);
        if (property != null) {
            this.cachedProxyData.put(propName, System.getProperty(propName));
        }
    }

    private void restoreProxySetting(String propName) {
        String cachedProperty;
        if (this.cachedProxyData.containsKey(propName) && (cachedProperty = this.cachedProxyData.get(propName)) != null) {
            System.setProperty(propName, this.cachedProxyData.get(propName));
        }
    }

    public String getHostAddress(boolean tryToUseSSL) {
        String repositoryLocationString = this.getRepositoryLocation(tryToUseSSL);
        URI repositoryLocation = URI.createURI((String)AbstractLocationsUtil.getExternalLocation(repositoryLocationString));
        return String.valueOf(repositoryLocation.scheme()) + "://" + repositoryLocation.host() + ":" + repositoryLocation.port();
    }

    public String getLocationPropertyValue(String locationName, String propertyName) {
        try {
            LocationProperty locationProperty = ModelBusConfiguration.getLocationProperty(locationName, propertyName);
            if (locationProperty != null) {
                return locationProperty.getValue();
            }
        }
        catch (ModelBusException modelBusException) {
            return null;
        }
        return null;
    }

    protected abstract boolean isSSLConnectionForced();

    protected abstract boolean enableTryToUseSSL();

    public abstract String getSecureRepositoryLocation();

    public abstract String getModelBusConfigModelFolderLocation() throws ModelBusException;

    public abstract String getModelBusConfigModelLocation() throws ModelBusException;
}

